/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesElementFactory {
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter) {
        String text = PropertiesElementFactory.getPropertyText(name, value, delimiter, project, true);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        return dummyFile.getProperties().get(0);
    }

    @Deprecated
    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        return PropertiesElementFactory.createProperty(project, name, value, null);
    }

    @NotNull
    public static String getPropertyText(@NonNls @NotNull String name, @NonNls @NotNull String value, @NonNls @Nullable Character delimiter, @Nullable Project project, boolean escape) {
        if (delimiter == null) {
            delimiter = Character.valueOf(project == null ? (char)'=' : PropertiesCodeStyleSettings.getInstance(project).getDelimiter());
        }
        return (escape ? PropertiesElementFactory.escape(name) : name) + String.valueOf(delimiter) + (escape ? PropertiesElementFactory.escapeValue(value, delimiter.charValue()) : value);
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, Properties properties, String fileName) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
    }

    @NotNull
    public static PropertiesFile getSystemProperties(@NotNull Project project) {
        return (PropertiesFile)PROPERTIES.get((UserDataHolder)project, null);
    }

    @NotNull
    private static String escape(@NotNull String name) {
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#') || StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = "\\" + name;
        }
        return StringUtil.escapeChars((String)name, (char[])new char[]{'=', ':', ' ', '\t'});
    }

    @Deprecated
    public static String escapeValue(String value) {
        return PropertiesElementFactory.escapeValue(value, '=');
    }

    public static String escapeValue(String value, char delimiter) {
        return PropertiesResourceBundleUtil.fromValueEditorToPropertyValue(value, delimiter);
    }
}

