/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesFileImpl
extends PsiFileBase
implements PropertiesFile {
    private static final Logger LOG = Logger.getInstance(PropertiesFileImpl.class);
    private static final TokenSet PROPERTIES_LIST_SET = TokenSet.create((IElementType[])new IElementType[]{PropertiesElementTypes.PROPERTIES_LIST});

    public PropertiesFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        return PropertiesFileType.INSTANCE;
    }

    @NonNls
    public String toString() {
        return "Properties file:" + this.getName();
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.getStubChildOfType((PsiElement)this, PropertiesList.class);
        if (propertiesList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)propertiesList, Property.class));
    }

    private ASTNode getPropertiesList() {
        return (ASTNode)ArrayUtil.getFirstElement((Object[])this.getNode().getChildren(PROPERTIES_LIST_SET));
    }

    @Override
    @Nullable
    public IProperty findPropertyByKey(@NotNull String key) {
        return this.propertiesByKey(key).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull String key) {
        return this.propertiesByKey(key).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        return PropertiesImplUtil.getResourceBundle(this);
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return PropertiesUtil.getLocale(this);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof Property) {
            throw new IncorrectOperationException("Use addProperty() instead");
        }
        return super.add(element);
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        IProperty position = this.findInsertionPosition(property);
        return this.addPropertyAfter(property, position);
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull IProperty property, @Nullable IProperty anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property.getPsiElement());
        List<IProperty> properties = this.getProperties();
        ASTNode aSTNode = anchor == null ? (properties.isEmpty() ? null : properties.get(0).getPsiElement().getNode()) : (anchorBefore = anchor.getPsiElement().getNode().getTreeNext());
        if (anchorBefore != null && anchorBefore.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorBefore.getTreeNext();
        }
        if (anchorBefore == null && this.haveToAddNewLine()) {
            this.insertLineBreakBefore(null);
        }
        this.getPropertiesList().addChild((ASTNode)copy, anchorBefore);
        if (anchorBefore != null) {
            this.insertLineBreakBefore(anchorBefore);
        }
        return copy.getPsi();
    }

    @Override
    @NotNull
    public IProperty addProperty(String key, String value) {
        return (IProperty)this.addProperty(PropertiesElementFactory.createProperty(this.getProject(), key, value, null));
    }

    @Override
    @NotNull
    public IProperty addPropertyAfter(String key, String value, @Nullable IProperty anchor) {
        return (IProperty)this.addPropertyAfter(PropertiesElementFactory.createProperty(this.getProject(), key, value, null), anchor);
    }

    private void insertLineBreakBefore(ASTNode anchorBefore) {
        this.getPropertiesList().addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), anchorBefore);
    }

    private boolean haveToAddNewLine() {
        ASTNode lastChild = this.getPropertiesList().getLastChildNode();
        return lastChild != null && !lastChild.getText().endsWith("\n");
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        return result;
    }

    @Override
    public boolean isAlphaSorted() {
        return PropertiesImplUtil.isAlphaSorted(this.getProperties());
    }

    private IProperty findInsertionPosition(@NotNull IProperty property) {
        List<IProperty> properties = this.getProperties();
        if (properties.isEmpty()) {
            return null;
        }
        if (PropertiesImplUtil.isAlphaSorted(properties)) {
            int insertIndex = Collections.binarySearch(this.getProperties(), property, (p1, p2) -> {
                String k1 = p1.getKey();
                String k2 = p2.getKey();
                LOG.assertTrue(k1 != null && k2 != null);
                return String.CASE_INSENSITIVE_ORDER.compare(k1, k2);
            });
            return insertIndex == -1 ? null : this.getProperties().get(insertIndex < 0 ? -insertIndex - 2 : insertIndex);
        }
        return (IProperty)ContainerUtil.getLastItem(properties);
    }

    private Stream<IProperty> propertiesByKey(@NotNull String key) {
        return this.getProperties().stream().filter(p -> key.equals(p.getUnescapedKey()));
    }
}

