/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleUtil;
import com.intellij.lang.properties.refactoring.rename.ResourceBundleRenameUtil;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleFromEditorRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundleUtil.getResourceBundleFromDataContext(dataContext);
        if (bundle == null) {
            return false;
        }
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (fileEditor == null || !(fileEditor instanceof ResourceBundleEditor)) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        return virtualFile != null && virtualFile instanceof ResourceBundleAsVirtualFile;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)((Object)PlatformDataKeys.FILE_EDITOR.getData(dataContext));
        assert (resourceBundleEditor != null);
        ResourceBundleEditorViewElement selectedElement = resourceBundleEditor.getSelectedElementIfOnlyOne();
        if (selectedElement != null) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (selectedElement instanceof PropertiesPrefixGroup) {
                    PropertiesPrefixGroup group = (PropertiesPrefixGroup)selectedElement;
                    ResourceBundleRenameUtil.renameResourceBundleKeySection(ResourceBundleFromEditorRenameHandler.getPsiElementsFromGroup(group), group.getPresentableName(), group.getPrefix().length() - group.getPresentableName().length());
                } else if (selectedElement instanceof ResourceBundlePropertyStructureViewElement) {
                    PsiElement psiElement = ((ResourceBundlePropertyStructureViewElement)selectedElement).getProperty().getPsiElement();
                    ResourceBundleRenameUtil.renameResourceBundleKey(psiElement, project);
                } else if (selectedElement instanceof ResourceBundleFileStructureViewElement) {
                    ResourceBundleRenameUtil.renameResourceBundleBaseName(((ResourceBundleFileStructureViewElement)selectedElement).getValue(), project);
                } else {
                    throw new IllegalStateException("unsupported type: " + selectedElement.getClass());
                }
            });
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        this.invoke(project, null, null, dataContext);
    }

    private static List<PsiElement> getPsiElementsFromGroup(PropertiesPrefixGroup propertiesPrefixGroup) {
        return ContainerUtil.mapNotNull(propertiesPrefixGroup.getChildren(), (Function)((NullableFunction)treeElement -> {
            if (treeElement instanceof PropertiesStructureViewElement) {
                return ((PropertiesStructureViewElement)treeElement).getValue().getPsiElement();
            }
            if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                return ((ResourceBundlePropertyStructureViewElement)treeElement).getProperty().getPsiElement();
            }
            return null;
        }));
    }
}

