/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.refactoring.rename.ResourceBundleRenamer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return false;
        }
        PropertiesFile file = PropertiesImplUtil.getPropertiesFile(element);
        if (file == null) {
            return false;
        }
        ResourceBundle resourceBundle = file.getResourceBundle();
        return resourceBundle.getBaseDirectory() != null && resourceBundle.getPropertiesFiles().size() != 1;
    }

    @Nullable
    public String getOptionName() {
        return PropertiesBundle.message("resource.bundle.renamer.option", new Object[0]);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)element);
        assert (propertiesFile != null);
        return new ResourceBundleRenamer(propertiesFile, newName);
    }
}

