/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DexApplication {
    private ProgramClassCollection programClasses;
    private ClasspathClassCollection classpathClasses;
    private LibraryClassCollection libraryClasses;
    public final ImmutableSet<DexType> mainDexList;
    public final byte[] deadCode;
    private final ClassNameMapper proguardMap;
    public final Timing timing;
    public final DexItemFactory dexItemFactory;
    public final DexString highestSortingString;

    private DexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, ImmutableSet<DexType> mainDexList, byte[] deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        assert (programClasses != null);
        this.proguardMap = proguardMap;
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
        this.mainDexList = mainDexList;
        this.deadCode = deadCode;
        this.dexItemFactory = dexItemFactory;
        this.highestSortingString = highestSortingString;
        this.timing = timing;
    }

    public Map<DexType, DexClass> getFullClassMap() {
        return this.forceLoadAllClasses();
    }

    private <T> boolean reorderClasses(List<T> classes) {
        Collections.shuffle(classes);
        return true;
    }

    public List<DexProgramClass> classes() {
        this.programClasses.forceLoad(type -> true);
        List<DexProgramClass> classes = this.programClasses.getAllClasses();
        assert (this.reorderClasses(classes));
        return classes;
    }

    public List<DexLibraryClass> libraryClasses() {
        assert (this.classpathClasses == null) : "Operation is not supported.";
        Map<DexType, DexClass> classMap = this.forceLoadAllClasses();
        ArrayList<DexLibraryClass> classes = new ArrayList<DexLibraryClass>();
        for (DexClass clazz : classMap.values()) {
            if (!clazz.isLibraryClass()) continue;
            classes.add(clazz.asLibraryClass());
        }
        assert (this.reorderClasses(classes));
        return classes;
    }

    private Map<DexType, DexClass> forceLoadAllClasses() {
        IdentityHashMap<DexType, DexClass> loaded = new IdentityHashMap<DexType, DexClass>();
        this.programClasses.forceLoad(type -> true);
        this.programClasses.getAllClasses().forEach(clazz -> {
            DexClass cfr_ignored_0 = loaded.put(clazz.type, (DexClass)clazz);
        });
        if (this.classpathClasses != null) {
            this.classpathClasses.forceLoad(type -> !loaded.containsKey(type));
            this.classpathClasses.getAllClasses().forEach(clazz -> {
                DexClass cfr_ignored_0 = loaded.putIfAbsent(clazz.type, (DexClass)clazz);
            });
        }
        if (this.libraryClasses != null) {
            this.libraryClasses.forceLoad(type -> !loaded.containsKey(type));
            this.libraryClasses.getAllClasses().forEach(clazz -> {
                DexClass cfr_ignored_0 = loaded.putIfAbsent(clazz.type, (DexClass)clazz);
            });
        }
        return loaded;
    }

    public DexClass definitionFor(DexType type) {
        if (type == null) {
            return null;
        }
        Object clazz = this.programClasses.get(type);
        if (clazz == null && this.classpathClasses != null) {
            clazz = this.classpathClasses.get(type);
        }
        if (clazz == null && this.libraryClasses != null) {
            clazz = this.libraryClasses.get(type);
        }
        return clazz;
    }

    public DexProgramClass programDefinitionFor(DexType type) {
        Object clazz = this.programClasses.get(type);
        return clazz == null ? null : ((DexClass)clazz).asProgramClass();
    }

    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public ClassNameMapper getProguardMap() {
        return this.proguardMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disassemble(DexEncodedMethod method, ClassNameMapper naming, Path outputDir) {
        if (method.getCode() != null) {
            PrintStream ps = System.out;
            try {
                String methodName;
                String clazzName;
                if (naming != null) {
                    clazzName = naming.originalNameOf(method.method.holder);
                    methodName = naming.originalSignatureOf(method.method).toString();
                } else {
                    clazzName = method.method.holder.toSourceString();
                    methodName = method.method.name.toString();
                }
                if (outputDir != null) {
                    Path directory = outputDir.resolve(clazzName.replace('.', '/'));
                    String name = methodName + ".dump";
                    if (name.length() > 200) {
                        name = StringUtils.computeMD5Hash(name);
                    }
                    Files.createDirectories(directory, new FileAttribute[0]);
                    ps = new PrintStream(Files.newOutputStream(directory.resolve(name), new OpenOption[0]));
                }
                ps.println("Bytecode for");
                ps.println("Class: '" + clazzName + "'");
                ps.println("Method: '" + methodName + "':");
                ps.println(method.getCode().toString(method, naming));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (outputDir != null) {
                    ps.flush();
                    ps.close();
                }
            }
        }
    }

    public void disassemble(Path outputDir, InternalOptions options) {
        for (DexProgramClass clazz : this.programClasses.getAllClasses()) {
            clazz.forEachMethod(method -> {
                if (options.methodMatchesFilter((DexEncodedMethod)method)) {
                    this.disassemble((DexEncodedMethod)method, this.getProguardMap(), outputDir);
                }
            });
        }
    }

    public String smali(InternalOptions options) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.smali(options, ps);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    private void writeClassHeader(DexClass clazz, PrintStream ps) {
        StringBuilder builder = new StringBuilder();
        builder.append(".class ");
        builder.append(clazz.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(clazz.type.toSmaliString());
        builder.append("\n\n");
        if (clazz.type != this.dexItemFactory.objectType) {
            builder.append(".super ");
            builder.append(clazz.superType.toSmaliString());
            builder.append("\n");
            for (DexType iface : clazz.interfaces.values) {
                builder.append(".implements ");
                builder.append(iface.toSmaliString());
                builder.append("\n");
            }
        }
        ps.append(builder.toString());
    }

    private void writeClassFooter(DexClass clazz, PrintStream ps) {
        StringBuilder builder = new StringBuilder();
        builder.append("# End of class ");
        builder.append(clazz.type.toSmaliString());
        builder.append("\n");
        ps.append(builder.toString());
    }

    public void smali(InternalOptions options, PrintStream ps) {
        List classes = this.programClasses.getAllClasses();
        classes.sort(Comparator.comparing(DexProgramClass::toSourceString));
        boolean firstClass = true;
        for (DexClass clazz : classes) {
            boolean classHeaderWritten = false;
            if (!options.hasMethodsFilter()) {
                if (!firstClass) {
                    ps.append("\n");
                    firstClass = false;
                }
                this.writeClassHeader(clazz, ps);
                classHeaderWritten = true;
            }
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                if (!options.methodMatchesFilter(method)) continue;
                if (!classHeaderWritten) {
                    if (!firstClass) {
                        ps.append("\n");
                        firstClass = false;
                    }
                    this.writeClassHeader(clazz, ps);
                    classHeaderWritten = true;
                }
                ps.append("\n");
                ps.append(method.toSmaliString(this.getProguardMap()));
            }
            for (DexEncodedMethod method : clazz.directMethods()) {
                if (!options.methodMatchesFilter(method)) continue;
                if (!classHeaderWritten) {
                    if (!firstClass) {
                        ps.append("\n");
                        firstClass = false;
                    }
                    this.writeClassHeader(clazz, ps);
                    classHeaderWritten = true;
                }
                ps.append("\n");
                ps.append(method.toSmaliString(this.getProguardMap()));
            }
            if (!classHeaderWritten) continue;
            ps.append("\n");
            this.writeClassFooter(clazz, ps);
        }
    }

    public static class Builder {
        private final List<DexProgramClass> programClasses;
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        public final DexItemFactory dexItemFactory;
        ClassNameMapper proguardMap;
        private final Timing timing;
        DexString highestSortingString;
        private byte[] deadCode;
        private final Set<DexType> mainDexList = Sets.newIdentityHashSet();

        public Builder(DexItemFactory dexItemFactory, Timing timing) {
            this.programClasses = new ArrayList<DexProgramClass>();
            this.dexItemFactory = dexItemFactory;
            this.timing = timing;
            this.deadCode = null;
            this.classpathClasses = null;
            this.libraryClasses = null;
        }

        public Builder(DexApplication application) {
            this.programClasses = application.programClasses.getAllClasses();
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
            this.proguardMap = application.proguardMap;
            this.timing = application.timing;
            this.highestSortingString = application.highestSortingString;
            this.dexItemFactory = application.dexItemFactory;
            this.mainDexList.addAll((Collection<DexType>)application.mainDexList);
            this.deadCode = application.deadCode;
        }

        public synchronized Builder setProguardMap(ClassNameMapper proguardMap) {
            assert (this.proguardMap == null);
            this.proguardMap = proguardMap;
            return this;
        }

        public synchronized Builder replaceProgramClasses(List<DexProgramClass> newProgramClasses) {
            assert (newProgramClasses != null);
            this.programClasses.clear();
            this.programClasses.addAll(newProgramClasses);
            return this;
        }

        public Builder appendDeadCode(byte[] deadCodeAtAnotherRound) {
            if (deadCodeAtAnotherRound == null) {
                return this;
            }
            if (this.deadCode == null) {
                this.deadCode = deadCodeAtAnotherRound;
                return this;
            }
            this.deadCode = Bytes.concat((byte[][])new byte[][]{this.deadCode, deadCodeAtAnotherRound});
            return this;
        }

        public synchronized Builder setHighestSortingString(DexString value) {
            this.highestSortingString = value;
            return this;
        }

        public synchronized Builder addProgramClass(DexProgramClass clazz) {
            this.programClasses.add(clazz);
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        public synchronized Builder addSynthesizedClass(DexProgramClass synthesizedClass, boolean addToMainDexList) {
            assert (synthesizedClass.isProgramClass()) : "All synthesized classes must be program classes";
            this.addProgramClass(synthesizedClass);
            if (addToMainDexList && !this.mainDexList.isEmpty()) {
                this.mainDexList.add(synthesizedClass.type);
            }
            return this;
        }

        public Collection<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public Builder addToMainDexList(Collection<DexType> mainDexList) {
            this.mainDexList.addAll(mainDexList);
            return this;
        }

        public DexApplication build() {
            return new DexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses), this.classpathClasses, this.libraryClasses, ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

