/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class CatchHandlers<T> {
    private final List<DexType> guards;
    private final List<T> targets;
    private Set<T> uniqueTargets;
    public static final CatchHandlers<Integer> EMPTY_INDICES = new CatchHandlers();
    public static final CatchHandlers<BasicBlock> EMPTY_BASIC_BLOCK = new CatchHandlers();

    private CatchHandlers() {
        this.guards = ImmutableList.of();
        this.targets = ImmutableList.of();
    }

    public CatchHandlers(List<DexType> guards, List<T> targets) {
        assert (!guards.isEmpty());
        assert (guards.size() == targets.size());
        this.guards = ImmutableList.copyOf(guards);
        this.targets = ImmutableList.copyOf(targets);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        assert (this.guards.size() == this.targets.size());
        return this.guards.size();
    }

    public List<DexType> getGuards() {
        return this.guards;
    }

    public List<T> getAllTargets() {
        return this.targets;
    }

    public Set<T> getUniqueTargets() {
        if (this.uniqueTargets == null) {
            this.uniqueTargets = ImmutableSet.copyOf(this.targets);
        }
        return this.uniqueTargets;
    }

    public boolean hasCatchAll() {
        return this.getGuards().size() > 0 && this.getGuards().get(this.getGuards().size() - 1) == DexItemFactory.catchAllType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatchHandlers)) {
            return false;
        }
        CatchHandlers that = (CatchHandlers)o;
        return this.guards.equals(that.guards) && this.targets.equals(that.targets);
    }

    public int hashCode() {
        return 31 * this.guards.hashCode() + this.targets.hashCode();
    }
}

