/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.provider;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.gradle.kotlin.dsl.provider.UnexpectedBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0013\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u001b\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"extractBuildscriptBlockFrom", "Lkotlin/ranges/IntRange;", "script", "", "extractTopLevelSectionFrom", "identifier", "expectNoMore", "", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "findBlockEnd", "", "(Lorg/jetbrains/kotlin/lexer/KotlinLexer;)Ljava/lang/Integer;", "findTopLevelIdentifier", "(Lorg/jetbrains/kotlin/lexer/KotlinLexer;Ljava/lang/String;)Ljava/lang/Integer;", "nextTopLevelSection", "skipWhiteSpaceAndComments", "provider_main"})
public final class BuildscriptBlockExtractionKt {
    @Nullable
    public static final IntRange extractBuildscriptBlockFrom(@NotNull String script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return BuildscriptBlockExtractionKt.extractTopLevelSectionFrom(script, "buildscript");
    }

    @Nullable
    public static final IntRange extractTopLevelSectionFrom(@NotNull String script, @NotNull String identifier) {
        KotlinLexer kotlinLexer;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        boolean bl = StringsKt.contains$default((CharSequence)script, (char)'\r', (boolean)false, (int)2, null) ^ true;
        if (!bl) {
            String string = "CR characters are not supported by the Kotlin lexer. Convert the line separators before attempting this operation.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        KotlinLexer $receiver = kotlinLexer = new KotlinLexer();
        $receiver.start((CharSequence)script);
        while ($receiver.getTokenType() != null) {
            IntRange intRange;
            IntRange intRange2 = BuildscriptBlockExtractionKt.nextTopLevelSection($receiver, identifier);
            if (intRange2 == null) continue;
            IntRange it = intRange = intRange2;
            $receiver.advance();
            BuildscriptBlockExtractionKt.expectNoMore($receiver, identifier);
            return it;
        }
        return null;
    }

    private static final void expectNoMore(@NotNull KotlinLexer $receiver, String identifier) {
        IntRange intRange = BuildscriptBlockExtractionKt.nextTopLevelSection($receiver, identifier);
        if (intRange != null) {
            IntRange intRange2;
            IntRange it = intRange2 = intRange;
            throw (Throwable)new UnexpectedBlock(identifier, it);
        }
    }

    private static final IntRange nextTopLevelSection(@NotNull KotlinLexer $receiver, String identifier) {
        IntRange intRange;
        Integer n = BuildscriptBlockExtractionKt.findTopLevelIdentifier($receiver, identifier);
        if (n != null) {
            Integer n2 = n;
            int sectionStart = ((Number)n2).intValue();
            $receiver.advance();
            BuildscriptBlockExtractionKt.skipWhiteSpaceAndComments($receiver);
            if (Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.LBRACE)) {
                Integer n3 = BuildscriptBlockExtractionKt.findBlockEnd($receiver);
                if (n3 != null) {
                    Integer n4 = n3;
                    int sectionEnd = ((Number)n4).intValue();
                    intRange = new IntRange(sectionStart, sectionEnd);
                } else {
                    intRange = null;
                }
            } else {
                intRange = null;
            }
        } else {
            intRange = null;
        }
        return intRange;
    }

    private static final void skipWhiteSpaceAndComments(@NotNull KotlinLexer $receiver) {
        while (KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains($receiver.getTokenType())) {
            $receiver.advance();
        }
    }

    private static final Integer findTopLevelIdentifier(@NotNull KotlinLexer $receiver, String identifier) {
        int depth = 0;
        while ($receiver.getTokenType() != null) {
            IElementType iElementType = $receiver.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IDENTIFIER)) {
                if (depth == 0 && Intrinsics.areEqual((Object)$receiver.getTokenText(), (Object)identifier)) {
                    return $receiver.getTokenStart();
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LBRACE)) {
                ++depth;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
                --depth;
            }
            $receiver.advance();
        }
        return null;
    }

    private static final Integer findBlockEnd(@NotNull KotlinLexer $receiver) {
        int depth = 0;
        while ($receiver.getTokenType() != null) {
            IElementType iElementType = $receiver.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LBRACE)) {
                ++depth;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
                if (depth == 1) {
                    return $receiver.getTokenStart();
                }
                --depth;
            }
            $receiver.advance();
        }
        return null;
    }
}

