/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.TestCaseLoader;
import com.intellij.TestRecorder;
import com.intellij.idea.Bombed;
import com.intellij.idea.RecordExecution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tests.ExternalClasspathClassLoader;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public class TestAll
implements Test {
    private static final int SAVE_MEMORY_SNAPSHOT = 1;
    private static final int START_GUARD = 2;
    private static final int RUN_GC = 4;
    private static final int CHECK_MEMORY = 8;
    private static final int FILTER_CLASSES = 16;
    private static final int ourMode = 17;
    private static final boolean PERFORMANCE_TESTS_ONLY;
    private static final boolean INCLUDE_PERFORMANCE_TESTS;
    private static final boolean INCLUDE_UNCONVENTIONALLY_NAMED_TESTS;
    private static final int MAX_FAILURE_TEST_COUNT = 150;
    private static final Filter PERFORMANCE_ONLY;
    private static final Filter NO_PERFORMANCE;
    private final TestCaseLoader myTestCaseLoader;
    private long myStartTime;
    private boolean myInterruptedByOutOfTime;
    private long myLastTestStartTime;
    private String myLastTestClass;
    private int myRunTests = -1;
    private boolean mySavingMemorySnapshot;
    private int myLastTestTestMethodCount;
    private TestRecorder myTestRecorder;
    private static final List<Throwable> outClassLoadingProblems;

    public TestAll(String packageRoot) throws Throwable {
        this(packageRoot, TestAll.getClassRoots());
    }

    public TestAll(String packageRoot, String ... classRoots) throws IOException, ClassNotFoundException {
        String classFilterName = "tests/testGroups.properties";
        if (Boolean.getBoolean("idea.ignore.predefined.groups")) {
            classFilterName = "";
        }
        this.myTestCaseLoader = new TestCaseLoader(classFilterName);
        this.myTestCaseLoader.addFirstTest(Class.forName("_FirstInSuiteTest"));
        this.myTestCaseLoader.addLastTest(Class.forName("_LastInSuiteTest"));
        TestAll.fillTestCases(this.myTestCaseLoader, packageRoot, classRoots);
        outClassLoadingProblems.addAll(this.myTestCaseLoader.getClassLoadingErrors());
    }

    public static List<Throwable> getLoadingClassProblems() {
        return outClassLoadingProblems;
    }

    public static String[] getClassRoots() {
        String testRoots = System.getProperty("test.roots");
        if (testRoots != null) {
            System.out.println("Collecting tests from roots specified by test.roots property: " + testRoots);
            return testRoots.split(";");
        }
        Object[] roots = ExternalClasspathClassLoader.getRoots();
        if (roots != null) {
            if (Comparing.equal((String)System.getProperty("idea.skip.community.tests"), (String)"true")) {
                System.out.println("Skipping community tests");
                Set<String> set2 = TestAll.normalizePaths((String[])roots);
                set2.removeAll(TestAll.normalizePaths(ExternalClasspathClassLoader.getExcludeRoots()));
                roots = ArrayUtil.toStringArray(set2);
            }
            System.out.println("Collecting tests from roots specified by classpath.file property: " + Arrays.toString(roots));
            return roots;
        }
        ClassLoader loader = TestAll.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            return TestAll.getClassRoots(((URLClassLoader)loader).getURLs());
        }
        Class<?> loaderClass = loader.getClass();
        if (loaderClass.getName().equals("com.intellij.util.lang.UrlClassLoader")) {
            try {
                Method declaredMethod = loaderClass.getDeclaredMethod("getBaseUrls", new Class[0]);
                List urls = (List)declaredMethod.invoke((Object)loader, new Object[0]);
                return TestAll.getClassRoots(urls.toArray(new URL[urls.size()]));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    private static String[] getClassRoots(URL[] urls) {
        Object[] classLoaderRoots = new String[urls.length];
        for (int i2 = 0; i2 < urls.length; ++i2) {
            classLoaderRoots[i2] = VfsUtilCore.urlToPath((String)VfsUtilCore.convertFromUrl((URL)urls[i2]));
        }
        System.out.println("Collecting tests from " + Arrays.toString(classLoaderRoots));
        return classLoaderRoots;
    }

    private static Set<String> normalizePaths(String[] array) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>(array.length);
        for (String path : array) {
            answer.add(path.replace('\\', '/'));
        }
        return answer;
    }

    public static void fillTestCases(TestCaseLoader testCaseLoader, String packageRoot, String ... classRoots) throws IOException {
        long before = System.currentTimeMillis();
        for (String classRoot : classRoots) {
            int oldCount = testCaseLoader.getClasses().size();
            File classRootFile = new File(FileUtil.toSystemDependentName((String)classRoot));
            ClassFinder classFinder = new ClassFinder(classRootFile, packageRoot, INCLUDE_UNCONVENTIONALLY_NAMED_TESTS);
            testCaseLoader.loadTestCases(classRootFile.getName(), classFinder.getClasses());
            int newCount = testCaseLoader.getClasses().size();
            if (newCount == oldCount) continue;
            System.out.println("Loaded " + (newCount - oldCount) + " tests from class root " + classRoot);
        }
        if (testCaseLoader.getClasses().size() == 1) {
            testCaseLoader.clearClasses();
        }
        long after2 = System.currentTimeMillis();
        String message2 = "Number of test classes found: " + testCaseLoader.getClasses().size() + " time to load: " + (after2 - before) / 1000L + "s.";
        System.out.println(message2);
        TestAll.log(message2);
    }

    public int countTestCases() {
        int count = 0;
        for (Class aClass : this.myTestCaseLoader.getClasses()) {
            Test test = TestAll.getTest(aClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void beforeFirstTest() {
        this.myStartTime = System.currentTimeMillis();
    }

    private static Thread getCurrentThread() {
        if (PlatformTestCase.ourTestThread != null) {
            return PlatformTestCase.ourTestThread;
        }
        return LightPlatformTestCase.ourTestThread;
    }

    private void addErrorMessage(TestResult testResult, String message2) {
        String processedTestsMessage = this.myRunTests <= 0 ? "None of tests was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message2));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        this.loadTestRecorder();
        TestListener testListener = TestAll.loadDiscoveryListener();
        if (testListener != null) {
            testResult.addListener(testListener);
        }
        List<Class> classes2 = this.myTestCaseLoader.getClasses();
        int totalTests = classes2.size();
        for (Class aClass : classes2) {
            boolean recording = false;
            if (this.myTestRecorder != null && TestAll.shouldRecord(aClass)) {
                this.myTestRecorder.beginRecording(aClass, aClass.getAnnotation(RecordExecution.class));
                recording = true;
            }
            try {
                this.runNextTest(testResult, totalTests, aClass);
            }
            finally {
                if (recording) {
                    this.myTestRecorder.endRecording();
                }
            }
            if (!testResult.shouldStop()) continue;
            break;
        }
        if (testListener instanceof Closeable) {
            try {
                ((Closeable)testListener).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TestAll.tryGc(10);
    }

    private static TestListener loadDiscoveryListener() {
        String discoveryListener = System.getProperty("test.discovery.listener");
        if (discoveryListener != null) {
            try {
                return (TestListener)Class.forName(discoveryListener).newInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private static boolean shouldRecord(@NotNull Class<?> aClass) {
        return aClass.getAnnotation(RecordExecution.class) != null;
    }

    private void loadTestRecorder() {
        String recorderClassName = System.getProperty("test.recorder.class");
        if (recorderClassName != null) {
            try {
                Class<?> recorderClass = Class.forName(recorderClassName);
                this.myTestRecorder = (TestRecorder)recorderClass.newInstance();
            }
            catch (Exception e) {
                System.out.println("Error loading test recorder class '" + recorderClassName + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNextTest(TestResult testResult, int totalTests, Class testCaseClass) {
        ++this.myRunTests;
        if (!this.checkAvailableMemory(35, testResult)) {
            testResult.stop();
            return;
        }
        if (testResult.errorCount() + testResult.failureCount() > 150) {
            this.addErrorMessage(testResult, "Too many errors. Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        if (this.myStartTime == 0L) {
            String loaderName = this.getClass().getClassLoader().getClass().getName();
            if (!loaderName.startsWith("com.intellij.")) {
                this.beforeFirstTest();
            }
        } else if (this.myInterruptedByOutOfTime) {
            this.addErrorMessage(testResult, "Time out in " + this.myLastTestClass + ". Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        TestAll.log("\nRunning " + testCaseClass.getName());
        Test test = TestAll.getTest(testCaseClass);
        if (test == null) {
            return;
        }
        this.myLastTestClass = testCaseClass.getName();
        this.myLastTestStartTime = System.currentTimeMillis();
        this.myLastTestTestMethodCount = test.countTestCases();
        try {
            test.run(testResult);
        }
        catch (OutOfMemoryError t) {
            try {
                this.mySavingMemorySnapshot = true;
                TestAll.log("OutOfMemoryError detected. Saving memory snapshot started");
            }
            finally {
                TestAll.log("Saving memory snapshot finished");
                this.mySavingMemorySnapshot = false;
            }
            testResult.addError(test, (Throwable)t);
        }
        catch (Throwable t) {
            testResult.addError(test, t);
        }
    }

    private boolean checkAvailableMemory(int neededMemory, TestResult testResult) {
        return true;
    }

    private static boolean possibleOutOfMemory(int neededMemory) {
        long meg;
        long needed;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long realFreeMemory = runtime.freeMemory() + maxMemory - runtime.totalMemory();
        return realFreeMemory < (needed = (long)neededMemory * (meg = 0x100000L));
    }

    static boolean isPerformanceTestsRun() {
        return PERFORMANCE_TESTS_ONLY;
    }

    private static boolean isIncludingPerformanceTestsRun() {
        return INCLUDE_PERFORMANCE_TESTS;
    }

    @Nullable
    private static Test getTest(final @NotNull Class<?> testCaseClass) {
        try {
            if ((testCaseClass.getModifiers() & 1) == 0) {
                return null;
            }
            Bombed classBomb = testCaseClass.getAnnotation(Bombed.class);
            if (classBomb != null && PlatformTestUtil.bombExplodes(classBomb)) {
                return new ExplodedBomb(testCaseClass.getName(), classBomb);
            }
            Method suiteMethod = TestAll.safeFindMethod(testCaseClass, "suite");
            if (suiteMethod != null && !TestAll.isPerformanceTestsRun()) {
                return (Test)suiteMethod.invoke(null, (Object[])ArrayUtil.EMPTY_CLASS_ARRAY);
            }
            if (TestRunnerUtil.isJUnit4TestClass(testCaseClass)) {
                boolean runEverything;
                JUnit4TestAdapter adapter = new JUnit4TestAdapter(testCaseClass);
                boolean bl = runEverything = TestAll.isIncludingPerformanceTestsRun() || TestAll.isPerformanceTest(null, testCaseClass) && TestAll.isPerformanceTestsRun();
                if (!runEverything) {
                    try {
                        adapter.filter(TestAll.isPerformanceTestsRun() ? PERFORMANCE_ONLY : NO_PERFORMANCE);
                    }
                    catch (NoTestsRemainException noTestsRemainException) {
                        // empty catch block
                    }
                }
                return adapter;
            }
            final int[] testsCount = new int[]{0};
            TestSuite suite = new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        this.doAddTest(test);
                    } else {
                        String name = ((TestCase)test).getName();
                        if ("warning".equals(name)) {
                            return;
                        }
                        if (!TestAll.isIncludingPerformanceTestsRun() && TestAll.isPerformanceTestsRun() ^ TestAll.isPerformanceTest(name, testCaseClass)) {
                            return;
                        }
                        Method method2 = this.findTestMethod((TestCase)test);
                        if (method2 == null) {
                            this.doAddTest(test);
                        } else {
                            Bombed methodBomb = method2.getAnnotation(Bombed.class);
                            if (methodBomb == null) {
                                this.doAddTest(test);
                            } else if (PlatformTestUtil.bombExplodes(methodBomb)) {
                                this.doAddTest((Test)new ExplodedBomb(method2.getDeclaringClass().getName() + "." + method2.getName(), methodBomb));
                            }
                        }
                    }
                }

                private void doAddTest(Test test) {
                    testsCount[0] = testsCount[0] + 1;
                    super.addTest(test);
                }

                @Nullable
                private Method findTestMethod(TestCase testCase) {
                    return TestAll.safeFindMethod(testCase.getClass(), testCase.getName());
                }
            };
            return testsCount[0] > 0 ? suite : null;
        }
        catch (Throwable t) {
            System.err.println("Failed to load test: " + testCaseClass.getName());
            t.printStackTrace(System.err);
            return null;
        }
    }

    static boolean shouldIncludePerformanceTestCase(Class aClass) {
        return TestAll.isIncludingPerformanceTestsRun() || TestAll.isPerformanceTestsRun() || !TestAll.isPerformanceTest(null, aClass);
    }

    private static boolean isPerformanceTest(String methodName, Class aClass) {
        return UsefulTestCase.isPerformanceTest(methodName, aClass.getSimpleName());
    }

    @Nullable
    private static Method safeFindMethod(Class<?> klass, String name) {
        return ReflectionUtil.getMethod(klass, (String)name, (Class[])new Class[0]);
    }

    private static void tryGc(int times) {
    }

    private static void log(String message2) {
        TeamCityLogger.info(message2);
    }

    static {
        Logger.setFactory(TestLoggerFactory.class);
        PERFORMANCE_TESTS_ONLY = System.getProperty("idea.performance.tests") != null;
        INCLUDE_PERFORMANCE_TESTS = System.getProperty("idea.include.performance.tests") != null;
        INCLUDE_UNCONVENTIONALLY_NAMED_TESTS = System.getProperty("idea.include.unconventionally.named.tests") != null;
        PERFORMANCE_ONLY = new Filter(){

            public boolean shouldRun(Description description) {
                String className = description.getClassName();
                String methodName = description.getMethodName();
                return UsefulTestCase.isPerformanceTest(methodName, className);
            }

            public String describe() {
                return "Performance Tests Only";
            }
        };
        NO_PERFORMANCE = new Filter(){

            public boolean shouldRun(Description description) {
                return !PERFORMANCE_ONLY.shouldRun(description);
            }

            public String describe() {
                return "All Except Performance";
            }
        };
        outClassLoadingProblems = new ArrayList<Throwable>();
    }

    private static class ExplodedBomb
    extends TestCase {
        private final Bombed myBombed;

        public ExplodedBomb(@NotNull String testName, @NotNull Bombed bombed) {
            super(testName);
            this.myBombed = bombed;
        }

        protected void runTest() throws Throwable {
            String description = this.myBombed.description().isEmpty() ? "" : " (" + this.myBombed.description() + ")";
            ExplodedBomb.fail((String)("Bomb created by " + this.myBombed.user() + description + " now explodes!"));
        }
    }
}

