/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CodeStyleConfigurableWrapper
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
OptionsContainingConfigurable {
    private boolean myInitialResetInvoked;
    protected CodeStyleMainPanel myPanel;
    private final CodeStyleSettingsProvider myProvider;
    private final CodeStyleSettingsPanelFactory myFactory;
    private CodeStyleSchemesConfigurable myOwner;

    public CodeStyleConfigurableWrapper(@NotNull CodeStyleSettingsProvider provider2, @NotNull CodeStyleSettingsPanelFactory factory, CodeStyleSchemesConfigurable owner) {
        this.myProvider = provider2;
        this.myFactory = factory;
        this.myOwner = owner;
        this.myInitialResetInvoked = false;
    }

    @Nls
    public String getDisplayName() {
        String displayName = this.myProvider.getConfigurableDisplayName();
        if (displayName != null) {
            return displayName;
        }
        return this.myPanel != null ? this.myPanel.getDisplayName() : null;
    }

    public String getHelpTopic() {
        return this.myPanel != null ? this.myPanel.getHelpTopic() : null;
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.ensureModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel;
    }

    protected boolean canBeShared() {
        return true;
    }

    public boolean isModified() {
        if (this.myPanel != null) {
            boolean someSchemeModified = this.myPanel.isModified();
            if (someSchemeModified) {
                this.myOwner.resetCompleted();
            }
            return someSchemeModified;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myOwner.apply();
    }

    public void resetPanel() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public String toString() {
        return this.myProvider.getClass().getName();
    }

    public void reset() {
        if (!this.myInitialResetInvoked) {
            try {
                this.myOwner.resetFromChild();
            }
            finally {
                this.myInitialResetInvoked = true;
            }
        } else {
            this.myOwner.revert();
        }
    }

    @NotNull
    public String getId() {
        return CodeStyleConfigurableWrapper.getConfigurableId(this.getDisplayName());
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUIResources();
        }
    }

    public boolean isPanelModified(CodeStyleScheme scheme2) {
        return this.myPanel != null && this.myPanel.isModified(scheme2);
    }

    public boolean isPanelModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void applyPanel() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    @Override
    public Set<String> processListOptions() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.ensureModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel.processListOptions();
    }

    @NotNull
    public static String getConfigurableId(String configurableDisplayName) {
        return "preferences.sourceCode." + configurableDisplayName;
    }
}

