/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();
    @NonNls
    public static final String[] PROTOCOLS;

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    public String substitute(@Nullable String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        return text;
    }

    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        boolean startsWith;
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        boolean bl = startsWith = caseSensitive ? text.startsWith(path) : StringUtil.startsWithIgnoreCase((String)text, (String)path);
        if (!startsWith) {
            return text;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && !text.substring(endOfOccurrence).startsWith("!/")) {
            return text;
        }
        return this.myMacroMap.get(path) + text.substring(endOfOccurrence);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacroRecursively(text, path, caseSensitive);
        }
        return text;
    }

    private String replacePathMacroRecursively(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text.length() < path.length()) {
            return text;
        }
        if (path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i = 0;
        while (i < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? text.indexOf(path, i) : StringUtil.indexOfIgnoreCase((String)text, (String)path, (int)i);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !text.substring(endOfOccurrence).startsWith("!/")) {
                    newText.append(text.substring(i, endOfOccurrence));
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text.substring(i, endOfOccurrence));
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text;
                }
                newText.append(text.substring(i));
                break;
            }
            newText.append(text.substring(i, occurrenceOfPath));
            newText.append(this.myMacroMap.get(path));
            i = occurrenceOfPath + path.length();
        }
        return newText.toString();
    }

    private static int getIndex(@NotNull Map.Entry<String, String> s) {
        String replacement = s.getValue();
        if (replacement.contains("..")) {
            return 1;
        }
        if (replacement.contains("$USER_HOME$")) {
            return 1;
        }
        if (replacement.contains("$APPLICATION_HOME_DIR$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$")) {
            return 3;
        }
        if (replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key2) {
        key2 = StringUtil.trimStart((String)key2, (String)"jar:");
        key2 = StringUtil.trimStart((String)key2, (String)"file:");
        while (key2.startsWith("/")) {
            key2 = key2.substring(1);
        }
        return key2.length();
    }

    @NotNull
    public List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap weights = new TObjectIntHashMap();
            for (Map.Entry entry2 : entries) {
                weights.put((Object)entry2, ReplacePathToMacroMap.getIndex(entry2) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            ContainerUtil.sort(entries, (o1, o2) -> weights.get(o2) - weights.get(o1));
            this.myPathsIndex = ContainerUtil.map2List(entries, entry -> (String)entry.getKey());
        }
        return this.myPathsIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME.getName())) {
            for (PathMacroExpandableProtocolBean bean : (PathMacroExpandableProtocolBean[])PathMacroExpandableProtocolBean.EP_NAME.getExtensions()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }
}

