/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesModel
implements SchemesModel<CodeStyleScheme> {
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme myGlobalSelected;
    private final CodeStyleSchemeImpl myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSettingsListener> myDispatcher = EventDispatcher.create(CodeStyleSettingsListener.class);
    private final Project myProject;
    private boolean myUsePerProjectSettings;
    public static final String PROJECT_SCHEME_NAME = "Project";

    public CodeStyleSchemesModel(Project project2) {
        this.myProject = project2;
        this.myProjectScheme = new CodeStyleSchemeImpl(PROJECT_SCHEME_NAME, false, CodeStyleSchemes.getInstance().getDefaultScheme());
        this.reset();
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
    }

    public void selectScheme(CodeStyleScheme selected, @Nullable Object source) {
        if (this.myGlobalSelected != selected && selected != this.myProjectScheme) {
            this.myGlobalSelected = selected;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    @Override
    public void removeScheme(@NotNull CodeStyleScheme scheme2) {
        this.mySchemes.remove(scheme2);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.myGlobalSelected == scheme2) {
            this.selectScheme(this.myDefault, this);
        }
    }

    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme2) {
        if (!this.mySettingsToClone.containsKey(scheme2)) {
            this.mySettingsToClone.put(scheme2, scheme2.getCodeStyleSettings().clone());
        }
        return this.mySettingsToClone.get(scheme2);
    }

    public CodeStyleScheme getSelectedScheme() {
        if (this.myUsePerProjectSettings) {
            return this.myProjectScheme;
        }
        return this.myGlobalSelected;
    }

    public void addListener(CodeStyleSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.myUsePerProjectSettings = this.getProjectSettings().USE_PER_PROJECT_SETTINGS;
        this.mySettingsToClone.clear();
        this.mySchemes.clear();
        ContainerUtil.addAll(this.mySchemes, CodeStyleSchemesImpl.getSchemeManager().getAllSchemes());
        this.myGlobalSelected = CodeStyleSchemes.getInstance().findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE);
        CodeStyleSettings perProjectSettings = this.getProjectSettings().PER_PROJECT_SETTINGS;
        if (perProjectSettings != null) {
            this.myProjectScheme.setCodeStyleSettings(perProjectSettings);
        }
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
    }

    public boolean isUsePerProjectSettings() {
        return this.myUsePerProjectSettings;
    }

    public void setUsePerProjectSettings(boolean usePerProjectSettings) {
        this.setUsePerProjectSettings(usePerProjectSettings, false);
    }

    public void setUsePerProjectSettings(boolean usePerProjectSettings, boolean commit) {
        if (commit) {
            CodeStyleSettingsManager projectSettings = this.getProjectSettings();
            projectSettings.USE_PER_PROJECT_SETTINGS = usePerProjectSettings;
            projectSettings.PER_PROJECT_SETTINGS = this.myProjectScheme.getCodeStyleSettings();
        }
        if (this.myUsePerProjectSettings != usePerProjectSettings) {
            this.myUsePerProjectSettings = usePerProjectSettings;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).usePerProjectSettingsOptionChanged();
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
        }
    }

    private CodeStyleSettingsManager getProjectSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myProject);
    }

    public boolean isSchemeListModified() {
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        if (this.getProjectSettings().USE_PER_PROJECT_SETTINGS != this.myUsePerProjectSettings) {
            return true;
        }
        if (!this.myUsePerProjectSettings && this.getSelectedScheme() != schemes.findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getSchemes());
        return !configuredSchemesSet.equals(new THashSet(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()));
    }

    public void apply() {
        CodeStyleSettingsManager projectSettingsManager = this.getProjectSettings();
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.myUsePerProjectSettings;
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.myUsePerProjectSettings || this.myGlobalSelected == null ? null : this.myGlobalSelected.getName();
        projectSettingsManager.PER_PROJECT_SETTINGS = this.myProjectScheme.getCodeStyleSettings();
        CodeStyleSchemesImpl.getSchemeManager().setSchemes(this.mySchemes, this.myGlobalSelected, null);
    }

    @Deprecated
    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return false;
    }

    public void fireBeforeCurrentSettingsChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).beforeCurrentSettingsChanged();
    }

    public void fireSchemeChanged(CodeStyleScheme scheme2) {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme2);
    }

    public void fireSchemeListChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
    }

    public void fireAfterCurrentSettingsChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).afterCurrentSettingsChanged();
    }

    public CodeStyleScheme getSelectedGlobalScheme() {
        return this.myGlobalSelected;
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(this.getCloneSettings(this.myProjectScheme));
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        boolean isProjectScheme = this.isProjectScheme(parentScheme);
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.containsScheme((String)name, isProjectScheme)), false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name, boolean isProjectScheme) {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            if (isProjectScheme != this.isProjectScheme(scheme2) || !name.equals(scheme2.getName())) continue;
            return scheme2;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull CodeStyleScheme scheme2) {
        return !this.isProjectScheme(scheme2);
    }

    @Override
    public boolean canResetScheme(@NotNull CodeStyleScheme scheme2) {
        return scheme2.isDefault();
    }

    @Override
    public boolean canDeleteScheme(@NotNull CodeStyleScheme scheme2) {
        return !this.isProjectScheme(scheme2) && !scheme2.isDefault();
    }

    @Override
    public boolean isProjectScheme(@NotNull CodeStyleScheme scheme2) {
        return this.myProjectScheme == scheme2;
    }

    @Override
    public boolean canRenameScheme(@NotNull CodeStyleScheme scheme2) {
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectScheme) {
        return this.findSchemeByName(name, isProjectScheme) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings;
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        return !defaults.equals((Object)(clonedSettings = this.getCloneSettings(scheme2)));
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
        schemes.addAll(this.getSchemes());
        schemes.add(this.myProjectScheme);
        Collections.sort(schemes, (s1, s2) -> {
            if (this.isProjectScheme((CodeStyleScheme)s1)) {
                return -1;
            }
            if (this.isProjectScheme((CodeStyleScheme)s2)) {
                return 1;
            }
            if (s1.isDefault()) {
                return -1;
            }
            if (s2.isDefault()) {
                return 1;
            }
            return s1.getName().compareToIgnoreCase(s2.getName());
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }
}

