/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset = false;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model) {
        this.myModel = model;
    }

    private void onCombo() {
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        if (selected != null) {
            if (this.myModel.isProjectScheme(selected)) {
                this.myModel.setUsePerProjectSettings(true);
            } else {
                this.myModel.selectScheme(selected, this);
                this.myModel.setUsePerProjectSettings(false);
            }
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
            schemes.addAll(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            if (this.myModel.isUsePerProjectSettings()) {
                this.selectScheme(this.myModel.getProjectScheme());
            } else {
                this.selectScheme(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            if (this.myModel.isUsePerProjectSettings()) {
                this.selectScheme(this.myModel.getProjectScheme());
            } else {
                this.selectScheme(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void usePerProjectSettingsOptionChanged() {
        if (this.myModel.isProjectScheme(this.myModel.getSelectedScheme())) {
            this.selectScheme(this.myModel.getProjectScheme());
        } else {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
    }

    @Override
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme2) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme2);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme2);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        return this.myModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }
}

