/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappingAndBracesPanel
extends OptionTableWithPreviewPanel {
    private MultiMap<String, String> myGroupToFields = new MultiMap();
    private Map<String, SettingsGroup> myFieldNameToGroup;

    public WrappingAndBracesPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS;
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        super.addOption(fieldName, title, groupName);
        if (groupName != null) {
            this.myGroupToFields.putValue((Object)groupName, (Object)fieldName);
        }
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, @NotNull String[] options, @NotNull int[] values) {
        super.addOption(fieldName, title, groupName, options, values);
        if (groupName == null) {
            this.myGroupToFields.putValue((Object)title, (Object)fieldName);
        }
    }

    @Override
    protected void initTables() {
        for (Map.Entry entry : CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType()).entrySet()) {
            CodeStyleSettingPresentation.SettingsGroup group = (CodeStyleSettingPresentation.SettingsGroup)entry.getKey();
            for (CodeStyleSettingPresentation setting : (List)entry.getValue()) {
                String fieldName = setting.getFieldName();
                String uiName = setting.getUiName();
                if (setting instanceof CodeStyleBoundedIntegerSettingPresentation) {
                    CodeStyleBoundedIntegerSettingPresentation intSetting = (CodeStyleBoundedIntegerSettingPresentation)setting;
                    int defaultValue = intSetting.getDefaultValue();
                    this.addOption(fieldName, uiName, group.name, intSetting.getLowerBound(), intSetting.getUpperBound(), defaultValue, intSetting.getValueUiName((Object)defaultValue));
                    continue;
                }
                if (setting instanceof CodeStyleSelectSettingPresentation) {
                    CodeStyleSelectSettingPresentation selectSetting = (CodeStyleSelectSettingPresentation)setting;
                    this.addOption(fieldName, uiName, group.name, selectSetting.getOptions(), selectSetting.getValues());
                    continue;
                }
                this.addOption(fieldName, uiName, group.name);
            }
        }
    }

    protected SettingsGroup getAssociatedSettingsGroup(String fieldName) {
        if (this.myFieldNameToGroup == null) {
            this.myFieldNameToGroup = ContainerUtil.newHashMap();
            Set groups = this.myGroupToFields.keySet();
            for (String group : groups) {
                Collection fields = this.myGroupToFields.get((Object)group);
                SettingsGroup settingsGroup = new SettingsGroup(group, fields);
                for (String field : fields) {
                    this.myFieldNameToGroup.put(field, settingsGroup);
                }
            }
        }
        return this.myFieldNameToGroup.get(fieldName);
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"wrapping.and.braces", (Object[])new Object[0]);
    }

    protected static class SettingsGroup {
        public final String title;
        public final Collection<String> commonCodeStyleSettingFieldNames;

        public SettingsGroup(@NotNull String title, @NotNull Collection<String> commonCodeStyleSettingFieldNames) {
            this.title = title;
            this.commonCodeStyleSettingFieldNames = commonCodeStyleSettingFieldNames;
        }
    }
}

