/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.application.options.codeStyle.arrangement.action.AbstractArrangementRuleAction;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.IconUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class AddArrangementRuleAction
extends AbstractArrangementRuleAction
implements DumbAware {
    public AddArrangementRuleAction() {
        this.getTemplatePresentation().setText(ApplicationBundle.message((String)"arrangement.action.rule.add.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ApplicationBundle.message((String)"arrangement.action.rule.add.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        e.getPresentation().setEnabled(control != null);
    }

    public void actionPerformed(AnActionEvent e) {
        int rowToEdit;
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            return;
        }
        control.hideEditor();
        TIntArrayList rows = control.getSelectedModelRows();
        ArrangementMatchingRulesModel model = control.getModel();
        if (rows.size() == 1) {
            rowToEdit = rows.get(0) + 1;
            model.insertRow(rowToEdit, new Object[]{this.createNewRule(control)});
        } else {
            rowToEdit = model.getSize();
            model.add(this.createNewRule(control));
        }
        this.showEditor(control, rowToEdit);
        control.getSelectionModel().setSelectionInterval(rowToEdit, rowToEdit);
        this.scrollRowToVisible(control, rowToEdit);
    }

    @NotNull
    protected Object createNewRule(@NotNull ArrangementMatchingRulesControl control) {
        return new EmptyArrangementRuleComponent(control.getEmptyRowHeight());
    }

    protected void showEditor(@NotNull ArrangementMatchingRulesControl control, int rowToEdit) {
        control.showEditor(rowToEdit);
    }
}

