/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.additional;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OptionGroup;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceArrangementPanel {
    @NotNull
    private final JComboBox myForceRearrangeComboBox = new JComboBox();
    @NotNull
    private final JPanel myPanel;

    public ForceArrangementPanel() {
        this.myForceRearrangeComboBox.setModel(new EnumComboBoxModel(SelectedMode.class));
        this.myForceRearrangeComboBox.setMaximumSize(this.myForceRearrangeComboBox.getPreferredSize());
        this.myPanel = this.createPanel();
    }

    public int getRearrangeMode() {
        return this.getSelectedMode().rearrangeMode;
    }

    public void setSelectedMode(@NotNull SelectedMode mode) {
        this.myForceRearrangeComboBox.setSelectedItem((Object)mode);
    }

    public void setSelectedMode(int mode) {
        SelectedMode toSetUp = SelectedMode.getByMode(mode);
        assert (toSetUp != null);
        this.setSelectedMode(toSetUp);
    }

    @NotNull
    public JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    private JPanel createPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"arrangement.settings.additional.title", (Object[])new Object[0]));
        JPanel textWithComboPanel = new JPanel();
        textWithComboPanel.setLayout(new BoxLayout(textWithComboPanel, 2));
        textWithComboPanel.add(new JLabel(ApplicationBundle.message((String)"arrangement.settings.additional.force.combobox.name", (Object[])new Object[0])));
        textWithComboPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)5, (int)0)));
        textWithComboPanel.add(this.myForceRearrangeComboBox);
        group.add((JComponent)textWithComboPanel);
        return group.createPanel();
    }

    @NotNull
    private SelectedMode getSelectedMode() {
        return (SelectedMode)((Object)this.myForceRearrangeComboBox.getSelectedItem());
    }

    private static enum SelectedMode {
        FROM_DIALOG(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.according.to.dialog", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_ACCORDIND_TO_DIALOG),
        ALWAYS(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.always", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_ALWAYS),
        NEVER(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.never", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_NEVER);

        public final int rearrangeMode;
        @NotNull
        private final String myName;

        private SelectedMode(String name, int mode) {
            this.myName = name;
            this.rearrangeMode = mode;
        }

        @Nullable
        private static SelectedMode getByMode(int mode) {
            for (SelectedMode currentMode : SelectedMode.values()) {
                if (currentMode.rearrangeMode != mode) continue;
                return currentMode;
            }
            return null;
        }

        @NotNull
        public String toString() {
            return this.myName;
        }
    }
}

