/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.color;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementColorsProviderImpl
implements ArrangementColorsProvider {
    @NotNull
    private final Map<ArrangementSettingsToken, TextAttributes> myNormalAttributesCache = ContainerUtilRt.newHashMap();
    @NotNull
    private final Map<ArrangementSettingsToken, TextAttributes> mySelectedAttributesCache = ContainerUtilRt.newHashMap();
    @NotNull
    private final TextAttributes myDefaultNormalAttributes = new TextAttributes();
    @NotNull
    private final TextAttributes myDefaultSelectedAttributes = new TextAttributes();
    @NotNull
    private final Color myDefaultNormalBorderColor;
    @NotNull
    private final Color myDefaultSelectedBorderColor;
    @Nullable
    private final ArrangementColorsAware myColorsAware;
    @Nullable
    private Color myCachedNormalBorderColor;
    @Nullable
    private Color myCachedSelectedBorderColor;

    public ArrangementColorsProviderImpl(@Nullable ArrangementColorsAware colorsAware) {
        this.myColorsAware = colorsAware;
        this.myDefaultNormalAttributes.setForegroundColor(UIUtil.getTreeTextForeground());
        this.myDefaultNormalAttributes.setBackgroundColor(UIUtil.getPanelBackground());
        this.myDefaultSelectedAttributes.setForegroundColor(UIUtil.getTreeSelectionForeground());
        this.myDefaultSelectedAttributes.setBackgroundColor(UIUtil.getTreeSelectionBackground());
        this.myDefaultNormalBorderColor = UIUtil.getBorderColor();
        Color selectionBorderColor = UIUtil.getTreeSelectionBorderColor();
        if (selectionBorderColor == null) {
            selectionBorderColor = GroupedElementsRenderer.SELECTED_FRAME_FOREGROUND;
        }
        this.myDefaultSelectedBorderColor = selectionBorderColor;
    }

    @NotNull
    public Color getBorderColor(boolean selected) {
        Color cached = selected ? this.myCachedSelectedBorderColor : this.myCachedNormalBorderColor;
        if (cached != null) {
            return cached;
        }
        Color result2 = null;
        if (this.myColorsAware != null) {
            result2 = this.myColorsAware.getBorderColor(EditorColorsManager.getInstance().getGlobalScheme(), selected);
        }
        if (result2 == null) {
            Color color = result2 = selected ? this.myDefaultSelectedBorderColor : this.myDefaultNormalBorderColor;
        }
        if (selected) {
            this.myCachedSelectedBorderColor = result2;
        } else {
            this.myCachedNormalBorderColor = result2;
        }
        return result2;
    }

    @NotNull
    public TextAttributes getTextAttributes(@NotNull ArrangementSettingsToken token, boolean selected) {
        TextAttributes cached = selected ? this.mySelectedAttributesCache.get(token) : this.myNormalAttributesCache.get(token);
        if (cached != null) {
            return cached;
        }
        TextAttributes result2 = null;
        if (this.myColorsAware != null) {
            result2 = this.myColorsAware.getTextAttributes(EditorColorsManager.getInstance().getGlobalScheme(), token, selected);
        }
        if (result2 == null) {
            TextAttributes textAttributes = result2 = selected ? this.myDefaultSelectedAttributes : this.myDefaultNormalAttributes;
        }
        if (selected) {
            this.mySelectedAttributesCache.put(token, result2);
        } else {
            this.myNormalAttributesCache.put(token, result2);
        }
        return result2;
    }

    public void refresh() {
        if (this.myColorsAware != null) {
            this.myNormalAttributesCache.clear();
            this.mySelectedAttributesCache.clear();
        }
    }
}

