/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractArrangementUiComponent
implements ArrangementUiComponent {
    @NotNull
    private final NotNullLazyValue<JComponent> myComponent = new NotNullLazyValue<JComponent>(){

        @NotNull
        protected JComponent compute() {
            JPanel result2 = new JPanel(new GridBagLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    Point point = UIUtil.getLocationOnScreen((JComponent)this);
                    if (point != null) {
                        Rectangle bounds = this.getBounds();
                        AbstractArrangementUiComponent.this.myScreenBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
                    }
                    if (!AbstractArrangementUiComponent.this.myEnabled && g instanceof Graphics2D) {
                        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                    }
                    super.paintComponent(g);
                }

                @Override
                public boolean isFocusOwner() {
                    Component[] components = this.getComponents();
                    if (components != null) {
                        for (Component component : components) {
                            if (!component.isFocusOwner()) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public boolean requestFocusInWindow() {
                    if (this.getComponentCount() > 0) {
                        return this.getComponent(0).requestFocusInWindow();
                    }
                    return super.requestFocusInWindow();
                }
            };
            result2.setOpaque(false);
            result2.add((Component)AbstractArrangementUiComponent.this.doGetUiComponent(), new GridBag().fillCell());
            return result2;
        }
    };
    @NotNull
    private final Set<ArrangementSettingsToken> myAvailableTokens = ContainerUtilRt.newHashSet();
    @Nullable
    private ArrangementUiComponent.Listener myListener;
    @Nullable
    private Rectangle myScreenBounds;
    private boolean myEnabled = true;

    protected AbstractArrangementUiComponent(ArrangementSettingsToken ... availableTokens) {
        this.myAvailableTokens.addAll(Arrays.asList(availableTokens));
    }

    protected AbstractArrangementUiComponent(@NotNull Collection<ArrangementSettingsToken> availableTokens) {
        this.myAvailableTokens.addAll(availableTokens);
    }

    @NotNull
    public Set<ArrangementSettingsToken> getAvailableTokens() {
        return this.myAvailableTokens;
    }

    @NotNull
    public final JComponent getUiComponent() {
        return (JComponent)this.myComponent.getValue();
    }

    protected abstract JComponent doGetUiComponent();

    public void setData(@NotNull Object data) {
    }

    public void setListener(@Nullable ArrangementUiComponent.Listener listener2) {
        this.myListener = listener2;
    }

    @Nullable
    public Rectangle getScreenBounds() {
        return this.myScreenBounds;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Nullable
    public Rectangle onMouseMove(@NotNull MouseEvent event) {
        return null;
    }

    public void onMouseRelease(@NotNull MouseEvent event) {
    }

    @Nullable
    public Rectangle onMouseExited() {
        return null;
    }

    @Nullable
    public Rectangle onMouseEntered(@NotNull MouseEvent e) {
        return null;
    }

    protected void fireStateChanged() {
        if (this.myListener != null) {
            this.myListener.stateChanged();
        }
    }

    public final void reset() {
        this.setEnabled(false);
        this.setSelected(false);
        this.doReset();
    }

    protected abstract void doReset();

    public boolean alwaysCanBeActive() {
        return false;
    }
}

