/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorSettingsUtil {
    private ColorSettingsUtil() {
    }

    public static Map<TextAttributesKey, String> keyToDisplayTextMap(ColorSettingsPage page) {
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)page);
        HashMap displayText = new HashMap();
        for (AttributesDescriptor attributeDescriptor : attributeDescriptors) {
            TextAttributesKey key2 = attributeDescriptor.getKey();
            displayText.put(key2, attributeDescriptor.getDisplayName());
        }
        return displayText;
    }

    public static List<AttributesDescriptor> getAllAttributeDescriptors(ColorAndFontDescriptorsProvider provider2) {
        ArrayList<AttributesDescriptor> result2 = new ArrayList<AttributesDescriptor>();
        Collections.addAll(result2, provider2.getAttributeDescriptors());
        if (ColorSettingsUtil.isInspectionColorsPage(provider2)) {
            ColorSettingsUtil.addInspectionSeverityAttributes(result2);
        }
        return result2;
    }

    private static boolean isInspectionColorsPage(ColorAndFontDescriptorsProvider provider2) {
        if (!(provider2 instanceof InspectionColorSettingsPage)) {
            return false;
        }
        for (ColorSettingsPage settingsPage : (ColorSettingsPage[])Extensions.getExtensions((ExtensionPointName)ColorSettingsPage.EP_NAME)) {
            if (settingsPage == provider2) break;
            if (!(settingsPage instanceof InspectionColorSettingsPage)) continue;
            return false;
        }
        return true;
    }

    private static void addInspectionSeverityAttributes(List<AttributesDescriptor> descriptors) {
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unknown.symbol", (Object[])new Object[0]), CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.deprecated.symbol", (Object[])new Object[0]), CodeInsightColors.DEPRECATED_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unused.symbol", (Object[])new Object[0]), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]), CodeInsightColors.ERRORS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.warning", (Object[])new Object[0]), CodeInsightColors.WARNINGS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.weak.warning", (Object[])new Object[0]), CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.problems", (Object[])new Object[0]), CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.duplicate", (Object[])new Object[0]), CodeInsightColors.DUPLICATE_FROM_SERVER));
        for (SeveritiesProvider provider2 : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider2.getSeveritiesHighlightInfoTypes()) {
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                descriptors.add(new AttributesDescriptor(ColorSettingsUtil.toDisplayName(attributesKey), attributesKey));
            }
        }
    }

    @NotNull
    private static String toDisplayName(@NotNull TextAttributesKey attributesKey) {
        return OptionsBundle.message((String)"options.java.attribute.descriptor.errors.group", (Object[])new Object[]{StringUtil.capitalize((String)attributesKey.getExternalName().toLowerCase().replaceAll("_", " "))});
    }
}

