/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowDescriptionPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomizedSwitcherPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private ColorSettingsPage myPage;
    private PreviewPanel myPreviewPanel;
    private ColorAndFontDescriptionPanel myColorAndFontPanel;
    private RainbowDescriptionPanel myRainbowPanel;
    private OptionsPanelImpl.ColorDescriptionPanel myActive;

    public CustomizedSwitcherPanel(@Nullable PreviewPanel previewPanel, @Nullable ColorSettingsPage page) {
        this.myPage = page;
        this.myPreviewPanel = previewPanel;
        this.myRainbowPanel = new RainbowDescriptionPanel();
        this.myColorAndFontPanel = new ColorAndFontDescriptionPanel();
        Dimension sizeR = this.myRainbowPanel.getPreferredSize();
        Dimension sizeC = this.myColorAndFontPanel.getPreferredSize();
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(Math.max(sizeR.getWidth(), sizeC.getWidth()), Math.max(sizeR.getHeight(), sizeC.getHeight()));
        this.setPreferredSize(preferredSize);
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void resetDefault() {
        if (this.myActive != null) {
            PaintLocker locker = new PaintLocker(this);
            try {
                this.setPreferredSize(this.getSize());
                this.remove(this.myActive.getPanel());
                this.myActive = null;
            }
            finally {
                locker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        JComponent newPanel;
        JComponent oldPanel = this.myActive == null ? null : this.myActive.getPanel();
        this.myActive = this.getPanelForDescriptor(descriptor);
        JComponent jComponent = newPanel = this.myActive == null ? null : this.myActive.getPanel();
        if (oldPanel != newPanel) {
            PaintLocker locker = new PaintLocker(this);
            try {
                if (oldPanel != null) {
                    this.remove(oldPanel);
                }
                if (newPanel != null) {
                    this.setPreferredSize(null);
                    this.add(newPanel);
                }
            }
            finally {
                locker.release();
            }
        }
        if (this.myActive != null) {
            this.myActive.reset(descriptor);
        }
        this.updatePreviewPanel(descriptor);
    }

    protected OptionsPanelImpl.ColorDescriptionPanel getPanelForDescriptor(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor instanceof RainbowAttributeDescriptor) {
            return this.myRainbowPanel;
        }
        if (descriptor instanceof ColorAndFontDescription) {
            return this.myColorAndFontPanel;
        }
        return null;
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor descriptor, EditorColorsScheme scheme2) {
        if (this.myActive != null) {
            this.myActive.apply(descriptor, scheme2);
            this.updatePreviewPanel(descriptor);
        }
    }

    protected void updatePreviewPanel(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (!(this.myPreviewPanel instanceof SimpleEditorPreview) || !(this.myPage instanceof RainbowColorSettingsPage)) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            SimpleEditorPreview simpleEditorPreview = (SimpleEditorPreview)this.myPreviewPanel;
            simpleEditorPreview.setupRainbow(descriptor.getScheme(), (RainbowColorSettingsPage)this.myPage);
            simpleEditorPreview.updateView();
        }));
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        this.myRainbowPanel.addListener(listener2);
        this.myColorAndFontPanel.addListener(listener2);
    }

    private static class PaintLocker {
        private Container myPaintHolder;
        private boolean myPaintState;

        public PaintLocker(@NotNull JComponent component) {
            this.myPaintHolder = component.getParent();
            this.myPaintState = this.myPaintHolder.getIgnoreRepaint();
            this.myPaintHolder.setIgnoreRepaint(true);
        }

        public void release() {
            this.myPaintHolder.validate();
            this.myPaintHolder.setIgnoreRepaint(this.myPaintState);
            this.myPaintHolder.repaint();
        }
    }
}

