/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JumpToColorsAndFontsAction
extends DumbAwareAction {
    public JumpToColorsAndFontsAction() {
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabledAndVisible(project2 != null && editor != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project2 == null || editor == null) {
            return;
        }
        HashMap keyMap = ContainerUtil.newHashMap();
        Processor processor2 = r -> {
            Pair p;
            Object tt = r.getErrorStripeTooltip();
            TextAttributesKey key2 = tt instanceof HighlightInfo ? (TextAttributesKey)ObjectUtils.chooseNotNull((Object)((HighlightInfo)tt).forcedTextAttributesKey, (Object)((HighlightInfo)tt).type.getAttributesKey()) : null;
            Pair pair = p = key2 == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key2);
            if (p != null) {
                keyMap.put(key2, p);
            }
            return true;
        };
        JBIterable editors = editor instanceof EditorWindow ? JBIterable.of((Object[])new Editor[]{editor, ((EditorWindow)editor).getDelegate()}) : JBIterable.of((Object)editor);
        block0: for (Editor ed : editors) {
            TextRange selection = EditorUtil.getSelectionInAnyMode(ed);
            MarkupModel forDocument = DocumentMarkupModel.forDocument(ed.getDocument(), project2, false);
            if (forDocument != null) {
                ((MarkupModelEx)forDocument).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), (Processor<? super RangeHighlighterEx>)processor2);
            }
            ((MarkupModelEx)ed.getMarkupModel()).processRangeHighlightersOverlappingWith(selection.getStartOffset(), selection.getEndOffset(), (Processor<? super RangeHighlighterEx>)processor2);
            EditorHighlighter highlighter = ed instanceof EditorEx ? ((EditorEx)ed).getHighlighter() : null;
            SyntaxHighlighter syntaxHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
            if (syntaxHighlighter == null) continue;
            HighlighterIterator iterator = highlighter.createIterator(selection.getStartOffset());
            while (!iterator.atEnd()) {
                for (TextAttributesKey key2 : syntaxHighlighter.getTokenHighlights(iterator.getTokenType())) {
                    Pair p;
                    Pair pair = p = key2 == null ? null : ColorSettingsPages.getInstance().getAttributeDescriptor(key2);
                    if (p == null) continue;
                    keyMap.put(key2, p);
                }
                if (iterator.getEnd() >= selection.getEndOffset()) continue block0;
                iterator.advance();
            }
        }
        if (keyMap.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No text attributes found");
        } else if (keyMap.size() == 1) {
            Pair p = (Pair)keyMap.values().iterator().next();
            if (!JumpToColorsAndFontsAction.openSettingsAndSelectKey(project2, (ColorSettingsPage)p.first, (AttributesDescriptor)p.second)) {
                HintManager.getInstance().showErrorHint(editor, "No appropriate settings page found");
            }
        } else {
            ArrayList attrs = ContainerUtil.newArrayList(keyMap.values());
            Collections.sort(attrs, (o1, o2) -> StringUtil.naturalCompare((String)(((ColorSettingsPage)o1.first).getDisplayName() + ((AttributesDescriptor)o1.second).getDisplayName()), (String)(((ColorSettingsPage)o2.first).getDisplayName() + ((AttributesDescriptor)o2.second).getDisplayName())));
            final EditorColorsScheme colorsScheme = editor.getColorsScheme();
            JBList list = new JBList((Collection)attrs);
            list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Pair<ColorSettingsPage, AttributesDescriptor>>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Pair<ColorSettingsPage, AttributesDescriptor>> list, Pair<ColorSettingsPage, AttributesDescriptor> value2, int index, boolean selected, boolean hasFocus) {
                    boolean addBoxed;
                    TextAttributes ta = colorsScheme.getAttributes(((AttributesDescriptor)value2.second).getKey());
                    Color fg = (Color)ObjectUtils.chooseNotNull((Object)ta.getForegroundColor(), (Object)colorsScheme.getDefaultForeground());
                    Color bg = (Color)ObjectUtils.chooseNotNull((Object)ta.getBackgroundColor(), (Object)colorsScheme.getDefaultBackground());
                    SimpleTextAttributes sa = SimpleTextAttributes.fromTextAttributes((TextAttributes)ta);
                    SimpleTextAttributes saOpaque = sa.derive(0x100 | sa.getStyle(), fg, bg, null);
                    SimpleTextAttributes saSelected = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(sa.getStyle(), null, null, null);
                    SimpleTextAttributes saCur = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    List split = StringUtil.split((String)(((ColorSettingsPage)value2.first).getDisplayName() + "//" + ((AttributesDescriptor)value2.second).getDisplayName()), (String)"//");
                    int len = split.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        boolean last;
                        boolean bl = last = i2 == len - 1;
                        SimpleTextAttributes simpleTextAttributes = !last ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (saCur = selected ? saSelected : saOpaque);
                        if (last) {
                            this.append(" ", saCur);
                        }
                        this.append((String)split.get(i2), saCur);
                        if (last) {
                            this.append(" ", saCur);
                            continue;
                        }
                        this.append(" > ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    Color stripeColor = ta.getErrorStripeColor();
                    boolean addStripe = stripeColor != null && stripeColor != saCur.getBgColor();
                    boolean bl = addBoxed = ta.getEffectType() == EffectType.BOXED && ta.getEffectColor() != null;
                    if (addBoxed) {
                        this.append("\u25a2" + (addStripe ? "" : " "), saCur.derive(-1, ta.getEffectColor(), null, null));
                    }
                    if (addStripe) {
                        this.append(" ", saCur.derive(256, null, stripeColor, null));
                    }
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(StringUtil.notNullize((String)e.getPresentation().getText())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                Pair p = (Pair)list.getSelectedValue();
                if (p != null && !JumpToColorsAndFontsAction.openSettingsAndSelectKey(project2, (ColorSettingsPage)p.first, (AttributesDescriptor)p.second)) {
                    HintManager.getInstance().showErrorHint(editor, "No appropriate settings page found");
                }
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    private static boolean openSettingsAndSelectKey(@NotNull Project project2, @NotNull ColorSettingsPage page, @NotNull AttributesDescriptor descriptor) {
        SearchableConfigurable configurable;
        SettingsDialog dialog2 = (SettingsDialog)ShowSettingsUtilImpl.getDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true), null);
        Settings settings = (Settings)Settings.KEY.getData((DataProvider)dialog2);
        ColorAndFontOptions configurable0 = settings == null ? null : settings.find(ColorAndFontOptions.class);
        SearchableConfigurable searchableConfigurable = configurable = configurable0 == null ? null : configurable0.findSubConfigurable(page.getDisplayName());
        if (configurable == null) {
            return false;
        }
        Runnable runnable2 = configurable.enableSearch(descriptor.getDisplayName());
        ActionCallback callback = settings.select((Configurable)configurable);
        if (runnable2 != null) {
            callback.doWhenDone(runnable2);
        }
        dialog2.show();
        return true;
    }
}

