/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorOptionsTree;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsPanelImpl
extends JPanel
implements OptionsPanel {
    public static final String SELECTED_COLOR_OPTION_PROPERTY = "selected.color.option.type";
    private final ColorOptionsTree myOptionsTree;
    private final ColorDescriptionPanel myOptionsPanel;
    private final ColorAndFontOptions myOptions;
    private final SchemesPanel mySchemesProvider;
    private final String myCategoryName;
    private final PropertiesComponent myProperties;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName) {
        this(options, schemesProvider, categoryName, new ColorAndFontDescriptionPanel());
    }

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName, ColorDescriptionPanel optionsPanel) {
        super(new BorderLayout());
        this.myOptions = options;
        this.mySchemesProvider = schemesProvider;
        this.myCategoryName = categoryName;
        this.myProperties = PropertiesComponent.getInstance();
        this.myOptionsPanel = optionsPanel;
        this.myOptionsPanel.addListener(new ColorDescriptionPanel.Listener(){

            @Override
            public void onSettingsChanged(ActionEvent e) {
                ((ColorAndFontSettingsListener)OptionsPanelImpl.this.myDispatcher.getMulticaster()).settingsChanged();
                OptionsPanelImpl.this.myOptions.stateChanged();
            }

            @Override
            public void onHyperLinkClicked(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String pageName;
                    Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)OptionsPanelImpl.this));
                    String attrName = e.getDescription();
                    Element element = e.getSourceElement();
                    try {
                        pageName = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    }
                    catch (BadLocationException e1) {
                        return;
                    }
                    SearchableConfigurable page = OptionsPanelImpl.this.myOptions.findSubConfigurable(pageName);
                    if (page != null && settings != null) {
                        Runnable runnable2 = page.enableSearch(attrName);
                        ActionCallback callback = settings.select((Configurable)page);
                        if (runnable2 != null) {
                            callback.doWhenDone(runnable2);
                        }
                    }
                }
            }
        });
        this.myOptions.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                if (OptionsPanelImpl.this.myOptionsTree.getSelectedValue() != null) {
                    OptionsPanelImpl.this.processListValueChanged();
                }
            }
        });
        this.myOptionsTree = new ColorOptionsTree(this.myCategoryName);
        this.myOptionsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                OptionsPanelImpl.this.processListValueChanged();
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myOptionsTree));
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.myOptionsPanel.getPanel(), "East");
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void processListValueChanged() {
        String preselectedType;
        EditorSchemeAttributeDescriptor description;
        Object selectedValue = this.myOptionsTree.getSelectedValue();
        EditorSchemeAttributeDescriptor editorSchemeAttributeDescriptor = description = selectedValue instanceof EditorSchemeAttributeDescriptor ? (EditorSchemeAttributeDescriptor)selectedValue : null;
        if (description == null && selectedValue == null && (preselectedType = this.myProperties.getValue(SELECTED_COLOR_OPTION_PROPERTY)) != null) {
            this.myOptionsTree.selectOptionByType(preselectedType);
            description = this.myOptionsTree.getSelectedDescriptor();
        }
        if (description != null) {
            this.myProperties.setValue(SELECTED_COLOR_OPTION_PROPERTY, description.getType());
            this.myOptionsPanel.reset(description);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(description);
        } else {
            this.myOptionsPanel.resetDefault();
        }
    }

    private void fillOptionsList() {
        this.myOptionsTree.fillOptions(this.myOptions);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void updateOptionsList() {
        this.fillOptionsList();
        this.processListValueChanged();
    }

    @Override
    public Runnable showOption(String attributeDisplayName) {
        return () -> this.myOptionsTree.selectOptionByName(attributeDisplayName);
    }

    @Override
    public void applyChangesToScheme() {
        EditorSchemeAttributeDescriptor descriptor = this.myOptionsTree.getSelectedDescriptor();
        if (descriptor != null) {
            this.myOptionsPanel.apply(descriptor, this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String attributeType) {
        this.myOptionsTree.selectOptionByType(attributeType);
    }

    @Override
    public Set<String> processListOptions() {
        EditorSchemeAttributeDescriptor[] descriptions;
        HashSet<String> result2 = new HashSet<String>();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            result2.add(description.toString());
        }
        return result2;
    }

    @Override
    public void setEmptyText(@NotNull String text, @Nullable ActionListener linkListener) {
        this.myOptionsTree.setEmptyText(text, linkListener);
    }

    public static interface ColorDescriptionPanel {
        @NotNull
        public JComponent getPanel();

        public void resetDefault();

        public void reset(@NotNull EditorSchemeAttributeDescriptor var1);

        public void apply(@NotNull EditorSchemeAttributeDescriptor var1, EditorColorsScheme var2);

        public void addListener(@NotNull Listener var1);

        public static interface Listener
        extends EventListener {
            public void onSettingsChanged(ActionEvent var1);

            public void onHyperLinkClicked(HyperlinkEvent var1);
        }
    }
}

