/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.RainbowColorsInSchemeState;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptorWithPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RainbowAttributeDescriptor
implements EditorSchemeAttributeDescriptorWithPath {
    private final String myGroup;
    private final String myDisplayName;
    private final EditorColorsScheme myScheme;
    private final Language myLanguage;
    private final RainbowColorsInSchemeState myRainbowColorsInSchemaState;

    public RainbowAttributeDescriptor(@Nullable Language language, @NotNull String group, @NotNull String displayNameWithPath, @NotNull EditorColorsScheme scheme2, @NotNull RainbowColorsInSchemeState rainbowState) {
        this.myLanguage = language;
        this.myDisplayName = displayNameWithPath;
        this.myRainbowColorsInSchemaState = rainbowState;
        this.myScheme = scheme2;
        this.myGroup = group;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public String getType() {
        return "rainbow";
    }

    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    public void apply(@Nullable EditorColorsScheme scheme2) {
        this.myRainbowColorsInSchemaState.apply(scheme2);
    }

    public boolean isModified() {
        return this.myRainbowColorsInSchemaState.isModified(this.myLanguage);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }
}

