/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InlineElementData
extends HighlightData {
    private final String myText;
    private boolean myAddBorder;

    public InlineElementData(int offset, TextAttributesKey attributesKey, String text) {
        this(offset, attributesKey, text, false);
    }

    private InlineElementData(int offset, TextAttributesKey attributesKey, String text, boolean highlighted) {
        super(offset, offset, attributesKey);
        this.myText = text;
        this.myAddBorder = highlighted;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public void addHighlToView(Editor view, EditorColorsScheme scheme2, Map<TextAttributesKey, String> displayText) {
        int offset = this.getStartOffset();
        ParameterHintsPresentationManager.getInstance().addHint(view, offset, this.myText, false);
        List inlays = view.getInlayModel().getInlineElementsInRange(offset, offset);
        for (Inlay inlay : inlays) {
            EditorCustomElementRenderer renderer = inlay.getRenderer();
            if (renderer instanceof RendererWrapper) continue;
            Disposer.dispose((Disposable)inlay);
            RendererWrapper wrapper = new RendererWrapper(renderer);
            wrapper.drawBorder = this.myAddBorder;
            view.getInlayModel().addInlineElement(offset, (EditorCustomElementRenderer)wrapper);
        }
    }

    @Override
    public void addToCollection(@NotNull Collection<HighlightData> list, boolean highlighted) {
        list.add(new InlineElementData(this.getStartOffset(), this.getHighlightKey(), this.myText, highlighted));
    }

    public static class RendererWrapper
    implements EditorCustomElementRenderer {
        private final EditorCustomElementRenderer myDelegate;
        private boolean drawBorder;

        public RendererWrapper(EditorCustomElementRenderer delegate) {
            this.myDelegate = delegate;
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            return this.myDelegate.calcWidthInPixels(editor);
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            TextAttributes attributes;
            this.myDelegate.paint(editor, g, r);
            if (this.drawBorder && (attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES)) != null && attributes.getEffectColor() != null) {
                g.setColor(attributes.getEffectColor());
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }
}

