/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.pathMacros.PathMacroListEditor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PathMacroConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String HELP_ID = "preferences.pathVariables";
    private PathMacroListEditor myEditor;

    public JComponent createComponent() {
        this.myEditor = new PathMacroListEditor();
        return this.myEditor.getPanel();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.commit();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            StorageUtilKt.checkUnknownMacros(project2, false);
        }
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.path.variables", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return HELP_ID;
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }
}

