/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    private final Collection<String> mySchemeImportersNames;
    private final Collection<String> mySchemeExporterNames;
    protected final AbstractSchemesPanel<T, ?> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        this.mySchemesPanel = schemesPanel;
        this.mySchemeImportersNames = this.getSchemeImportersNames();
        this.mySchemeExporterNames = this.getSchemeExporterNames();
    }

    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.name);
        }
        return importersNames;
    }

    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.name);
        }
        return exporterNames;
    }

    public final Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        this.addAdditionalActions(actions);
        if (!this.mySchemeExporterNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), this.mySchemeExporterNames, (x$0, x$1) -> new ExportAction((String)x$0, (String)x$1)));
        }
        actions.add((AnAction)new Separator());
        if (!this.mySchemeImportersNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), this.mySchemeImportersNames, (x$0, x$1) -> new ImportAction((String)x$0, (String)x$1)));
        }
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<AnAction> defaultActions) {
    }

    private static AnAction createImportExportAction(@NotNull String groupName, @NotNull Collection<String> actionNames, final @NotNull BiFunction<String, String, AnAction> createActionByName) {
        if (actionNames.size() == 1) {
            return createActionByName.apply((String)ContainerUtil.getFirstItem(actionNames), groupName + "...");
        }
        return new ImportExportActionGroup(groupName, actionNames){

            @Override
            @NotNull
            protected AnAction createAction(@NotNull String actionName) {
                return (AnAction)createActionByName.apply(actionName, actionName);
            }
        };
    }

    protected abstract void importScheme(@NotNull String var1);

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    protected void deleteScheme(@NotNull T scheme2) {
        if (Messages.showOkCancelDialog((String)("Do you want to delete \"" + scheme2.getName() + "\" scheme?"), (String)"Delete Scheme", (Icon)Messages.getQuestionIcon()) == 0) {
            this.mySchemesPanel.getModel().removeScheme(scheme2);
        }
    }

    protected abstract void exportScheme(@NotNull T var1, @NotNull String var2);

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme2) {
    }

    protected void copyToIDE(@NotNull T scheme2) {
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        return this.mySchemesPanel.getModel();
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    protected abstract Class<T> getSchemeType();

    public final AbstractSchemesPanel<T, ?> getSchemesPanel() {
        return this.mySchemesPanel;
    }

    private class ExportAction
    extends DumbAwareAction {
        private String myExporterName;

        public ExportAction(@NotNull String exporterName, String exporterText) {
            super(exporterText);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.exportScheme(currentScheme, this.myExporterName);
            }
        }
    }

    private class ImportAction
    extends DumbAwareAction {
        private String myImporterName;

        public ImportAction(@NotNull String importerName, String importerText) {
            super(importerText);
            this.myImporterName = importerName;
        }

        public void actionPerformed(AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }
    }

    private static abstract class ImportExportActionGroup
    extends ActionGroup {
        private final Collection<String> myActionNames;

        public ImportExportActionGroup(@NotNull String groupName, @NotNull Collection<String> actionNames) {
            super(groupName, true);
            this.myActionNames = actionNames;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
            for (String actionName : this.myActionNames) {
                namedActions.add(this.createAction(actionName));
            }
            return namedActions.toArray(new AnAction[namedActions.size()]);
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);
    }

    private class DeleteAction
    extends DumbAwareAction {
        public DeleteAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme2));
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        public RenameAction() {
            super("Rename...");
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.startEdit();
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme2));
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        public CopyAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                boolean isProjectScheme = AbstractSchemeActions.this.mySchemesPanel.supportsProjectSchemes() && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme);
                AbstractSchemeActions.this.duplicateScheme(currentScheme, SchemeNameGenerator.getUniqueName(SchemeManager.getDisplayName(currentScheme), name -> AbstractSchemeActions.this.mySchemesPanel.getModel().containsScheme((String)name, isProjectScheme)));
                currentScheme = AbstractSchemeActions.this.getCurrentScheme();
                if (currentScheme != null) {
                    AbstractSchemeActions.this.mySchemesPanel.startEdit();
                }
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme2));
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        public ResetAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme2)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme2));
            } else {
                p.setEnabledAndVisible(false);
            }
        }
    }

    private class CopyToIDEAction
    extends DumbAwareAction {
        public CopyToIDEAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }

    private class CopyToProjectAction
    extends DumbAwareAction {
        public CopyToProjectAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }
}

