/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.EditableSchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemesPanel<T extends Scheme, InfoComponent extends JComponent>
extends JPanel {
    private EditableSchemesCombo<T> mySchemesCombo;
    private AbstractSchemeActions<T> myActions;
    private JComponent myToolbar;
    protected InfoComponent myInfoComponent;
    protected final Color HINT_FOREGROUND = JBColor.GRAY;
    protected final Color ERROR_MESSAGE_FOREGROUND = Color.RED;

    public AbstractSchemesPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.createUIComponents();
    }

    private void createUIComponents() {
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        controlsPanel.add(new JLabel(this.getSchemeTypeName() + ":"));
        controlsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.myActions = this.createSchemeActions();
        this.mySchemesCombo = new EditableSchemesCombo(this);
        controlsPanel.add(this.mySchemesCombo.getComponent());
        this.myToolbar = this.createToolbar();
        controlsPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        controlsPanel.add(this.myToolbar);
        controlsPanel.add(Box.createRigidArea(new Dimension(9, 0)));
        this.myInfoComponent = this.createInfoComponent();
        controlsPanel.add((Component)this.myInfoComponent);
        controlsPanel.add(Box.createHorizontalGlue());
        controlsPanel.setMaximumSize(new Dimension(controlsPanel.getMaximumSize().width, this.mySchemesCombo.getComponent().getPreferredSize().height));
        this.add(controlsPanel);
        this.add(Box.createRigidArea(new Dimension(0, 12)));
        this.add(new JSeparator());
        this.add(Box.createVerticalGlue());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private JComponent createToolbar() {
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("NavBarToolbar", (ActionGroup)toolbarActionGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarActionGroup.add((AnAction)new ShowSchemesActionsListAction(this.myActions.getActions(), toolbarComponent));
        toolbarComponent.setMaximumSize(new Dimension(toolbarComponent.getPreferredSize().width, Short.MAX_VALUE));
        return toolbarComponent;
    }

    public final JComponent getToolbar() {
        return this.myToolbar;
    }

    protected abstract AbstractSchemeActions<T> createSchemeActions();

    public final T getSelectedScheme() {
        return this.mySchemesCombo.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme2) {
        this.mySchemesCombo.selectScheme(scheme2);
    }

    public final void resetSchemes(@NotNull Collection<T> schemes) {
        this.mySchemesCombo.resetSchemes(schemes);
    }

    public void disposeUIResources() {
        this.removeAll();
    }

    public final void startEdit() {
        this.mySchemesCombo.startEdit();
    }

    public final void cancelEdit() {
        this.mySchemesCombo.cancelEdit();
    }

    public final void showInfo(@Nullable String message2, @NotNull MessageType messageType) {
        this.myToolbar.setVisible(false);
        this.showMessage(message2, messageType);
    }

    protected abstract void showMessage(@Nullable String var1, @NotNull MessageType var2);

    public final void clearInfo() {
        this.myToolbar.setVisible(true);
        this.clearMessage();
    }

    protected abstract void clearMessage();

    public final AbstractSchemeActions<T> getActions() {
        return this.myActions;
    }

    @NotNull
    protected abstract InfoComponent createInfoComponent();

    protected String getSchemeTypeName() {
        return ApplicationBundle.message((String)"editbox.scheme.type.name", (Object[])new Object[0]);
    }

    @NotNull
    public abstract SchemesModel<T> getModel();

    public final void updateOnCurrentSettingsChange() {
        this.mySchemesCombo.updateSelected();
    }

    protected abstract boolean supportsProjectSchemes();

    protected abstract boolean highlightNonDefaultSchemes();

    public void showStatus(String message2, MessageType messageType) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(5000L);
        Balloon balloon = balloonBuilder.createBalloon();
        Point pointOnComponent = new Point(this.myToolbar.getWidth() / 4, this.myToolbar.getHeight() / 4);
        balloon.show(new RelativePoint((Component)this.myToolbar, pointOnComponent), Balloon.Position.above);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    private static class ShowSchemesActionsListAction
    extends DumbAwareAction {
        private final ActionGroup myActionGroup;
        private final Component myParentComponent;

        ShowSchemesActionsListAction(Collection<AnAction> actions, Component component) {
            this.myParentComponent = component;
            this.myActionGroup = new DefaultActionGroup(actions.toArray(new AnAction[actions.size()]));
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setIcon(AllIcons.General.Gear);
        }

        public void actionPerformed(AnActionEvent e) {
            ListPopup actionGroupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.myActionGroup, e.getDataContext(), true, null, Integer.MAX_VALUE);
            actionGroupPopup.show(new RelativePoint(this.myParentComponent, new Point(2, this.myParentComponent.getHeight() - 1)));
        }
    }
}

