/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableSchemesCombo<T extends Scheme> {
    public static final String EMPTY_NAME_MESSAGE = "The name must not be empty";
    public static final String NAME_ALREADY_EXISTS_MESSAGE = "Name is already in use. Please change to unique name.";
    private static final String EDITING_HINT = "Enter to save, Esc to cancel";
    public static final int COMBO_WIDTH = 200;
    private SchemesCombo<T> myComboBox;
    private JPanel myRootPanel;
    private AbstractSchemesPanel<T, ?> mySchemesPanel;
    private final CardLayout myLayout;
    private final JTextField myNameEditorField;
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);

    public EditableSchemesCombo(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        this.mySchemesPanel = schemesPanel;
        this.myLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myLayout);
        this.createCombo();
        this.myRootPanel.add((Component)((Object)this.myComboBox));
        this.myNameEditorField = this.createNameEditorField();
        this.myRootPanel.add(this.myNameEditorField);
        this.myRootPanel.setPreferredSize(new Dimension(JBUI.scale((int)200), this.myNameEditorField.getPreferredSize().height));
        this.myRootPanel.setMaximumSize(new Dimension(JBUI.scale((int)200), Short.MAX_VALUE));
    }

    private JTextField createNameEditorField() {
        JTextField nameEditorField = new JTextField();
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.revertSchemeName();
                EditableSchemesCombo.this.cancelEdit();
            }
        }, ESC_KEY_STROKE, 0);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        }, ENTER_KEY_STROKE, 0);
        nameEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        });
        nameEditorField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditableSchemesCombo.this.validateOnTyping();
            }
        });
        return nameEditorField;
    }

    private void validateOnTyping() {
        String validationMessage;
        String currName = this.myNameEditorField.getText();
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem != null && !currName.equals(((SchemesCombo.MySchemeListItem)selectedItem).getSchemeName()) && (validationMessage = this.validateSchemeName(currName, this.mySchemesPanel.getModel().isProjectScheme((Scheme)ObjectUtils.notNull(((SchemesCombo.MySchemeListItem)selectedItem).getScheme())))) != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            return;
        }
        this.showHint();
    }

    private void showHint() {
        this.mySchemesPanel.showInfo(EDITING_HINT, MessageType.INFO);
    }

    private void revertSchemeName() {
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem != null) {
            this.myNameEditorField.setText(((SchemesCombo.MySchemeListItem)selectedItem).getSchemeName());
        }
    }

    public void updateSelected() {
        this.myComboBox.repaint();
    }

    private void stopEdit() {
        String newName = this.myNameEditorField.getText();
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem != null) {
            if (newName.equals(((SchemesCombo.MySchemeListItem)selectedItem).getSchemeName())) {
                this.cancelEdit();
                return;
            }
            boolean isProjectScheme = this.mySchemesPanel.getModel().isProjectScheme((Scheme)ObjectUtils.notNull(((SchemesCombo.MySchemeListItem)selectedItem).getScheme()));
            String validationMessage = this.validateSchemeName(newName, isProjectScheme);
            if (validationMessage != null) {
                this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            } else {
                this.cancelEdit();
                if (((SchemesCombo.MySchemeListItem)selectedItem).getScheme() != null) {
                    this.mySchemesPanel.getActions().renameScheme(((SchemesCombo.MySchemeListItem)selectedItem).getScheme(), newName);
                }
            }
        }
    }

    public void cancelEdit() {
        this.mySchemesPanel.clearInfo();
        this.myLayout.first(this.myRootPanel);
        IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
        focusManager.doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myRootPanel, true));
    }

    private void createCombo() {
        this.myComboBox = new SchemesCombo<T>(){

            @Override
            protected boolean supportsProjectSchemes() {
                return EditableSchemesCombo.this.mySchemesPanel.supportsProjectSchemes();
            }

            @Override
            protected boolean isProjectScheme(@NotNull T scheme2) {
                return EditableSchemesCombo.this.mySchemesPanel.getModel().isProjectScheme(scheme2);
            }

            @Override
            @NotNull
            protected SimpleTextAttributes getSchemeAttributes(T scheme2) {
                SimpleTextAttributes baseAttributes;
                SchemesModel model = EditableSchemesCombo.this.mySchemesPanel.getModel();
                SimpleTextAttributes simpleTextAttributes = baseAttributes = model.canDeleteScheme(scheme2) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (EditableSchemesCombo.this.mySchemesPanel.highlightNonDefaultSchemes() && model.canResetScheme(scheme2) && model.differsFromDefault(scheme2)) {
                    return baseAttributes.derive(-1, (Color)JBColor.BLUE, null, null);
                }
                return baseAttributes;
            }
        };
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.mySchemesPanel.getActions().onSchemeChanged(EditableSchemesCombo.this.getSelectedScheme());
            }
        });
    }

    public void startEdit() {
        T scheme2 = this.getSelectedScheme();
        if (scheme2 != null) {
            this.showHint();
            this.myNameEditorField.setText(scheme2.getName());
            this.myLayout.last(this.myRootPanel);
            IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
            focusManager.doWhenFocusSettlesDown(() -> focusManager.requestFocus((Component)this.myNameEditorField, true));
        }
    }

    public void resetSchemes(@NotNull Collection<T> schemes) {
        this.myComboBox.resetSchemes(schemes);
    }

    @Nullable
    public T getSelectedScheme() {
        return this.myComboBox.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme2) {
        this.myComboBox.selectScheme(scheme2);
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @Nullable
    private String validateSchemeName(@NotNull String name, boolean isProjectScheme) {
        if (name.isEmpty()) {
            return EMPTY_NAME_MESSAGE;
        }
        if (this.mySchemesPanel.getModel().containsScheme(name, isProjectScheme)) {
            return NAME_ALREADY_EXISTS_MESSAGE;
        }
        return null;
    }
}

