/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor;

import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEditorFileSwapper
extends EditorFileSwapper {
    @Override
    public Pair<VirtualFile, Integer> getFileToSwapTo(Project project2, EditorWithProviderComposite editor) {
        VirtualFile file2 = editor.getFile();
        VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile(project2, file2);
        if (sourceFile == null) {
            return null;
        }
        Integer position = null;
        TextEditorImpl oldEditor = JavaEditorFileSwapper.findSinglePsiAwareEditor(editor.getEditors());
        if (oldEditor != null) {
            PsiElement navigationElement;
            PsiCompiledFile clsFile = (PsiCompiledFile)PsiManager.getInstance((Project)project2).findFile(file2);
            assert (clsFile != null);
            int offset = oldEditor.getEditor().getCaretModel().getOffset();
            PsiElement elementAt = clsFile.findElementAt(offset);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMember.class, (boolean)false);
            if (member instanceof PsiClass) {
                boolean isFirstMember = true;
                for (PsiElement e = member.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!(e instanceof PsiMember)) continue;
                    if (offset < e.getTextRange().getEndOffset()) {
                        if (isFirstMember) break;
                        member = (PsiMember)e;
                        break;
                    }
                    isFirstMember = false;
                }
            }
            if (member != null && Comparing.equal((Object)(navigationElement = member.getNavigationElement()).getContainingFile().getVirtualFile(), (Object)sourceFile)) {
                position = navigationElement.getTextOffset();
            }
        }
        return Pair.create((Object)sourceFile, position);
    }

    @Nullable
    public static VirtualFile findSourceFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        PsiClass sourceClass;
        PsiClass[] classes2;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile instanceof PsiCompiledFile && psiFile instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)psiFile).getClasses()).length != 0 && classes2[0] instanceof ClsClassImpl && (sourceClass = ((ClsClassImpl)classes2[0]).getSourceMirrorClass()) != null) {
            VirtualFile result2 = sourceClass.getContainingFile().getVirtualFile();
            assert (result2 != null) : sourceClass;
            return result2;
        }
        return null;
    }
}

