/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSeparatorProvider {
    @Nullable
    public static List<LineMarkerInfo> getFileSeparators(PsiFile file2, Document document) {
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        for (LineMarkerInfo lineMarkerInfo : LineMarkersPass.queryLineMarkers(file2, document)) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result2.add(lineMarkerInfo);
        }
        Collections.sort(result2, (i1, i2) -> FileSeparatorProvider.getDisplayLine(i1, document) - FileSeparatorProvider.getDisplayLine(i2, document));
        return result2;
    }

    public static int getDisplayLine(@NotNull LineMarkerInfo lineMarkerInfo, @NotNull Document document) {
        int offset = lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? lineMarkerInfo.startOffset : lineMarkerInfo.endOffset;
        return document.getLineNumber(Math.min(document.getTextLength(), Math.max(0, offset))) + (lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? 0 : 1);
    }
}

