/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColorGenerator {
    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull List<Color> anchorColors, int colorsBetweenAnchors) {
        assert (colorsBetweenAnchors >= 0);
        if (anchorColors.isEmpty()) {
            return Collections.singletonList(JBColor.GRAY);
        }
        if (anchorColors.size() == 1) {
            return Collections.singletonList(anchorColors.get(0));
        }
        int segmentCount = anchorColors.size() - 1;
        ArrayList<Color> result2 = new ArrayList<Color>(anchorColors.size() + segmentCount * colorsBetweenAnchors);
        result2.add(anchorColors.get(0));
        for (int i = 0; i < segmentCount; ++i) {
            Color color1 = anchorColors.get(i);
            Color color2 = anchorColors.get(i + 1);
            List<Color> linearColors = ColorGenerator.generateLinearColorSequence(color1, color2, colorsBetweenAnchors);
            result2.addAll(linearColors.subList(1, linearColors.size()));
        }
        return result2;
    }

    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull Color color1, @NotNull Color color2, int colorsBetweenAnchors) {
        assert (colorsBetweenAnchors >= 0);
        ArrayList<Color> result2 = new ArrayList<Color>(colorsBetweenAnchors + 2);
        result2.add(color1);
        for (int i = 1; i <= colorsBetweenAnchors; ++i) {
            float ratio = (float)i / (float)(colorsBetweenAnchors + 1);
            result2.add(new Color(ColorGenerator.ratio(color1.getRed(), color2.getRed(), ratio), ColorGenerator.ratio(color1.getGreen(), color2.getGreen(), ratio), ColorGenerator.ratio(color1.getBlue(), color2.getBlue(), ratio)));
        }
        result2.add(color2);
        return result2;
    }

    private static int ratio(int val1, int val2, float ratio) {
        int value2 = (int)((float)val1 + (float)(val2 - val1) * ratio);
        return Math.max(Math.min(value2, 255), 0);
    }
}

