/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(PsiElement ... elements) {
        List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(elements);
        if (exceptions.isEmpty()) {
            return exceptions;
        }
        exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        return exceptions;
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(@NotNull List<PsiClassType> exceptions) {
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            array.add(exception);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList;
            if (element instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)element).getArgumentList()) != null) {
                return ExceptionUtil.getThrownExceptions((PsiElement)argumentList);
            }
            return Collections.emptyList();
        }
        if (element instanceof PsiLambdaExpression) {
            return Collections.emptyList();
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result2 = methodRef.advancedResolve(false);
            return ExceptionUtil.getExceptionsByMethodAndChildren(element, result2);
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result3 = ((PsiNewExpression)element).resolveMethodGenerics();
            return ExceptionUtil.getExceptionsByMethodAndChildren(element, result3);
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                return Collections.emptyList();
            }
            List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(expr);
            ArrayList<PsiClassType> classTypes = new ArrayList<PsiClassType>(ContainerUtil.mapNotNull(types, (Function)((NullableFunction)type2 -> type2 instanceof PsiClassType ? (PsiClassType)type2 : null)));
            ExceptionUtil.addExceptions(classTypes, ExceptionUtil.getThrownExceptions((PsiElement)expr));
            return classTypes;
        }
        if (element instanceof PsiTryStatement) {
            return ExceptionUtil.getTryExceptions((PsiTryStatement)element);
        }
        if (element instanceof PsiResourceListElement) {
            PsiResourceVariable variable;
            PsiExpression initializer;
            ArrayList types = ContainerUtil.newArrayList();
            ExceptionUtil.addExceptions(types, ExceptionUtil.getCloserExceptions((PsiResourceListElement)element));
            if (element instanceof PsiResourceVariable && (initializer = (variable = (PsiResourceVariable)element).getInitializer()) != null) {
                ExceptionUtil.addExceptions(types, ExceptionUtil.getThrownExceptions((PsiElement)initializer));
            }
            return types;
        }
        return ExceptionUtil.getThrownExceptions(element.getChildren());
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        ArrayList array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiCodeBlock[] resource : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, (PsiElement)resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        for (PsiResourceListElement psiResourceListElement : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiResourceListElement.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom((PsiType)exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)psiCodeBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions((PsiElement)finallyBlock);
                if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        return array;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(@NotNull PsiElement element, @NotNull JavaResolveResult resolveResult) {
        ArrayList result2 = ContainerUtil.newArrayList();
        PsiMethod method2 = (PsiMethod)resolveResult.getElement();
        if (method2 != null) {
            ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method2, resolveResult.getSubstitutor(), element));
        }
        ExceptionUtil.addExceptions(result2, ExceptionUtil.getThrownExceptions(element.getChildren()));
        return result2;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes = method2.getThrowsList().getReferencedTypes();
        if (referenceTypes.length == 0) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiClassType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)type2), scope)) instanceof PsiClassType)) continue;
            result2.add(type2);
        }
        return result2;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom((PsiType)exception)) {
                return;
            }
            if (!exception.isAssignableFrom((PsiType)exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        return ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        Set<PsiClassType> set2 = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls);
        return set2 == null ? Collections.emptyList() : set2;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        AbstractCollection unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, includeSelfCalls);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2 = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression2 != null ? ExceptionUtil.collectUnhandledExceptions((PsiElement)qualifierExpression2, topElement, null, false) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement2 = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement2, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer.getBody(), (PsiElement)initializer, (Set<PsiClassType>)thrownByInitializer, includeSelfCalls);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.isHandled((PsiElement)constructor.getBody(), thrown, topElement)) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, includeSelfCalls);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve2 = resolveResult.getElement();
        if (resolve2 instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            return ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve2, referenceNameElement, topElement, resolveResult.getSubstitutor());
        }
        return Collections.emptyList();
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method2 != null && method2.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        final ArrayList array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                PsiMethod method2 = enumConstant.resolveMethod();
                if (method2 != null) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(method2, (PsiElement)enumConstant, null, PsiSubstitutor.EMPTY));
                }
                this.visitElement((PsiElement)enumConstant);
            }

            public void visitCallExpression(@NotNull PsiCallExpression expression2) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression2, null));
                this.visitElement((PsiElement)expression2);
            }

            public void visitThrowStatement(@NotNull PsiThrowStatement statement2) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement2, null));
                this.visitElement((PsiElement)statement2);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression2, null));
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitResourceVariable(@NotNull PsiResourceVariable resource) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, null));
                this.visitElement((PsiElement)resource);
            }

            public void visitResourceExpression(@NotNull PsiResourceExpression resource) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, null));
                this.visitElement((PsiElement)resource);
            }

            public void visitClass(PsiClass aClass) {
            }
        };
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)visitor);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement element) {
        return ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        return ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        PsiClassType[] thrownExceptions;
        PsiMethod method2;
        if (MethodCandidateInfo.isOverloadCheck()) {
            return Collections.emptyList();
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)methodCall.getArgumentList());
        MethodCandidateInfo result2 = properties != null ? properties.getInfo() : InferenceSession.getResolveResult((PsiCall)methodCall);
        PsiElement element = result2.getElement();
        PsiMethod psiMethod = method2 = element instanceof PsiMethod ? (PsiMethod)element : null;
        if (method2 == null) {
            return Collections.emptyList();
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        if (!includeSelfCalls && method2 == containingMethod) {
            return Collections.emptyList();
        }
        if (properties != null) {
            PsiUtilCore.ensureValid((PsiElement)method2);
        }
        if ((thrownExceptions = method2.getThrowsList().getReferencedTypes()).length == 0) {
            return Collections.emptyList();
        }
        PsiSubstitutor substitutor = result2.getSubstitutor();
        if (!ExceptionUtil.isArrayClone(method2, (PsiElement)methodCall) && methodCall instanceof PsiMethodCallExpression) {
            PsiFile containingFile = (containingMethod == null ? methodCall : containingMethod).getContainingFile();
            MethodResolverProcessor processor2 = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
            try {
                PsiScopesUtil.setupAndRunProcessor(processor2, methodCall, false);
                List candidates = ContainerUtil.mapNotNull(processor2.getResults(), info -> {
                    PsiElement element1 = info.getElement();
                    if (info instanceof MethodCandidateInfo && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method2, (PsiMethod)((PsiMethod)element1)) && !MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)element1), (PsiMethod)method2)) {
                        return Pair.create((Object)((PsiMethod)element1), (Object)((MethodCandidateInfo)info).getSubstitutor(false));
                    }
                    return null;
                });
                if (candidates.size() > 1) {
                    GlobalSearchScope scope = methodCall.getResolveScope();
                    List<PsiClassType> ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
                    for (Pair pair : candidates) {
                        PsiClassType[] exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            return ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                        }
                        ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                    }
                    return ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()]));
                }
            }
            catch (MethodProcessorSetupFailedException ignore) {
                return Collections.emptyList();
            }
        }
        return ExceptionUtil.getUnhandledExceptions(method2, (PsiElement)methodCall, topElement, substitutor);
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator = ex.iterator();
        while (iterator.hasNext()) {
            PsiClassType classType = iterator.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom((PsiType)classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom((PsiType)psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex = ExceptionUtil.getExceptionsFromClose(resource);
        return ex != null ? ex : Collections.emptyList();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        PsiType type2 = resource.getType();
        return ExceptionUtil.getUnhandledCloserExceptions((PsiElement)resource, topElement, type2);
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        return ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()])) : Collections.emptyList();
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods = PsiUtil.getResourceCloserMethodsForType((PsiClassType)((PsiClassType)type2));
        if (methods != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method2 : methods) {
                PsiSubstitutor substitutor;
                PsiClass closerClass = method2.getContainingClass();
                if (closerClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)closerClass, (PsiClass)resourceClass, (PsiSubstitutor)resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method2.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        SmartList unhandled = new SmartList();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled((PsiElement)throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        return unhandled;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter((PsiElement)target)) {
            return ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            return Collections.singletonList(type2);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method2, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor) {
        if (ExceptionUtil.isArrayClone(method2, element)) {
            return Collections.emptyList();
        }
        PsiClassType[] referencedTypes = method2.getThrowsList().getReferencedTypes();
        return ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor, referencedTypes);
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute((PsiType)referencedType), (boolean)false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result2.add((PsiClassType)type2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method2, PsiElement element) {
        if (!method2.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression2 = methodCallExpression.getQualifierExpression();
            return qualifierExpression2 != null && qualifierExpression2.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression3 = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression3 != null && qualifierExpression3.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        return ExceptionUtil.isGeneralExceptionType((PsiType)type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText = type2.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(@NotNull PsiClassType exceptionType, @NotNull PsiElement throwPlace) {
        return ExceptionUtil.isHandled(throwPlace, exceptionType, (PsiElement)throwPlace.getContainingFile());
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method2, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression || parent instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                    return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : (CustomExceptionHandler[])Extensions.getExtensions(CustomExceptionHandler.KEY)) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return true;
                }
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)interfaceType)))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method2, @NotNull PsiClassType exceptionType) {
        return ExceptionUtil.isHandledByMethodThrowsClause(method2, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method2, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        PsiClassType[] referencedTypes = method2.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, PsiSubstitutor.EMPTY);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(@NotNull List<PsiClassType> exceptions) {
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable((PsiType)((PsiType)exceptions.get(i)), (PsiType)((PsiType)exceptions.get(i + 1)))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }
}

