/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ReadableExternalAnnotationsManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.OptionsMessageDialog;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsManagerImpl
extends ReadableExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalAnnotationsManagerImpl.class.getName()));
    private final MessageBus myBus;

    public ExternalAnnotationsManagerImpl(@NotNull Project project2, PsiManager psiManager) {
        super(psiManager);
        this.myBus = project2.getMessageBus();
        MessageBusConnection connection = this.myBus.connect((Disposable)project2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ExternalAnnotationsManagerImpl.this.dropCache();
            }
        });
        MyVirtualFileListener fileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)fileListener);
        Disposer.register((Disposable)this.myPsiManager.getProject(), () -> VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)fileListener));
    }

    private void notifyAfterAnnotationChanging(@NotNull PsiModifierListOwner owner, @NotNull String annotationFQName, boolean successful) {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).afterExternalAnnotationChanging(owner, annotationFQName, successful);
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incCounter();
    }

    private void notifyChangedExternally() {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).externalAnnotationsChangedExternally();
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        LOG.assertTrue(!application.isWriteAccessAllowed());
        Project project2 = this.myPsiManager.getProject();
        PsiFile containingFile = listOwner.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        String packageName = ((PsiJavaFile)containingFile).getPackageName();
        VirtualFile containingVirtualFile = containingFile.getVirtualFile();
        LOG.assertTrue(containingVirtualFile != null);
        List entries = ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(containingVirtualFile);
        if (entries.isEmpty()) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        for (OrderEntry entry : entries) {
            if (entry instanceof ModuleOrderEntry) continue;
            VirtualFile[] roots = AnnotationOrderRootType.getFiles(entry);
            if ((roots = ExternalAnnotationsManagerImpl.filterByReadOnliness(roots)).length > 0) {
                this.chooseRootAndAnnotateExternally(listOwner, annotationFQName, fromFile, project2, packageName, roots, value2);
                break;
            }
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                return;
            }
            DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(true);
            try {
                if (!this.setupRootAndAnnotateExternally(entry, project2, listOwner, annotationFQName, fromFile, packageName, value2)) {
                    throw ExternalAnnotationsManager.CanceledConfigurationException.INSTANCE;
                }
                break;
            }
            finally {
                DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(false);
            }
        }
    }

    @Nullable
    private List<XmlFile> findExternalAnnotationsXmlFiles(@NotNull PsiModifierListOwner listOwner) {
        List<PsiFile> psiFiles2 = this.findExternalAnnotationsFiles(listOwner);
        if (psiFiles2 == null) {
            return null;
        }
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        for (PsiFile psiFile : psiFiles2) {
            if (!(psiFile instanceof XmlFile)) continue;
            xmlFiles.add((XmlFile)psiFile);
        }
        return xmlFiles;
    }

    private boolean setupRootAndAnnotateExternally(final @NotNull OrderEntry entry, @NotNull Project project2, final @NotNull PsiModifierListOwner listOwner, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @NotNull String packageName, final @Nullable PsiNameValuePair[] value2) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(ProjectBundle.message((String)"external.annotations.root.chooser.title", (Object[])new Object[]{entry.getPresentableName()}));
        descriptor.setDescription(ProjectBundle.message((String)"external.annotations.root.chooser.description", (Object[])new Object[0]));
        final VirtualFile newRoot = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, null);
        if (newRoot == null) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return false;
        }
        new WriteCommandAction(project2, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                ExternalAnnotationsManagerImpl.this.appendChosenAnnotationsRoot(entry, newRoot);
                XmlFile xmlFileInRoot = ExternalAnnotationsManagerImpl.findXmlFileInRoot(ExternalAnnotationsManagerImpl.this.findExternalAnnotationsXmlFiles(listOwner), newRoot);
                if (xmlFileInRoot != null) {
                    if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)xmlFileInRoot)) {
                        ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                        return;
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, xmlFileInRoot, fromFile, value2);
                } else {
                    XmlFile annotationsXml = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(newRoot, packageName);
                    if (annotationsXml != null) {
                        SmartList createdFiles = new SmartList((Object)annotationsXml);
                        ExternalAnnotationsManagerImpl.this.cacheExternalAnnotations(packageName, fromFile, (List<PsiFile>)createdFiles);
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, annotationsXml, fromFile, value2);
                }
            }
        }.execute();
        return true;
    }

    @Nullable
    private static XmlFile findXmlFileInRoot(@Nullable List<XmlFile> xmlFiles, @NotNull VirtualFile root) {
        if (xmlFiles != null) {
            for (XmlFile xmlFile : xmlFiles) {
                VirtualFile vf = xmlFile.getVirtualFile();
                if (vf == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vf, (boolean)false)) continue;
                return xmlFile;
            }
        }
        return null;
    }

    private void chooseRootAndAnnotateExternally(final @NotNull PsiModifierListOwner listOwner, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @NotNull Project project2, final @NotNull String packageName, @NotNull VirtualFile[] roots, final @Nullable PsiNameValuePair[] value2) {
        if (roots.length > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>("Annotation Roots", roots){

                public void canceled() {
                    ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                }

                public PopupStep onChosen(@NotNull VirtualFile file2, boolean finalChoice) {
                    ExternalAnnotationsManagerImpl.this.annotateExternally(file2, listOwner, project2, packageName, annotationFQName, fromFile, value2);
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(@NotNull VirtualFile value22) {
                    return value22.getPresentableUrl();
                }

                public Icon getIconFor(VirtualFile aValue) {
                    return AllIcons.Modules.Annotation;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else {
            this.annotateExternally(roots[0], listOwner, project2, packageName, annotationFQName, fromFile, value2);
        }
    }

    @NotNull
    private static VirtualFile[] filterByReadOnliness(@NotNull VirtualFile[] files) {
        List result2 = ContainerUtil.filter((Object[])files, VirtualFile::isInLocalFileSystem);
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    private void annotateExternally(final @NotNull VirtualFile root, final @NotNull PsiModifierListOwner listOwner, @NotNull Project project2, final @NotNull String packageName, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @Nullable PsiNameValuePair[] value2) {
        List<XmlFile> xmlFiles = this.findExternalAnnotationsXmlFiles(listOwner);
        final XmlFile existingXml = ExternalAnnotationsManagerImpl.findXmlFileInRoot(xmlFiles, root);
        if (existingXml != null && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)existingXml)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        THashSet annotationFiles = xmlFiles == null ? new THashSet() : new THashSet(xmlFiles);
        new WriteCommandAction(project2, new PsiFile[0], (Set)annotationFiles, project2){
            final /* synthetic */ Set val$annotationFiles;
            final /* synthetic */ Project val$project;
            {
                this.val$annotationFiles = set2;
                this.val$project = project2;
                super(arg0, arg1);
            }

            protected void run(@NotNull Result result2) throws Throwable {
                if (existingXml != null) {
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, existingXml, fromFile, value2);
                } else {
                    XmlFile newXml = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(root, packageName);
                    if (newXml == null) {
                        ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                    } else {
                        this.val$annotationFiles.add(newXml);
                        ExternalAnnotationsManagerImpl.this.cacheExternalAnnotations(packageName, fromFile, (List<PsiFile>)new SmartList((Collection)this.val$annotationFiles));
                        ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, newXml, fromFile, value2);
                    }
                }
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() {
                        ExternalAnnotationsManagerImpl.this.dropCache();
                        ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                    }

                    public void redo() {
                        ExternalAnnotationsManagerImpl.this.dropCache();
                        ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                    }
                });
            }
        }.execute();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<XmlTag>)((Processor)annotationTag -> {
            PsiElement parent = annotationTag.getParent();
            annotationTag.delete();
            if (parent instanceof XmlTag && ((XmlTag)parent).getSubTags().length == 0) {
                parent.delete();
            }
            return true;
        }));
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<XmlTag>)((Processor)annotationTag -> {
            annotationTag.replace((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQN, value2)));
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processExistingExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @NotNull Processor<XmlTag> annotationTagProcessor) {
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(listOwner);
            if (files == null) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQN, false);
                boolean bl = false;
                return bl;
            }
            boolean processedAnything = false;
            for (XmlFile file2 : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file2.isValid() || ReadonlyStatusHandler.getInstance((Project)this.myPsiManager.getProject()).ensureFilesWritable(new VirtualFile[]{file2.getVirtualFile()}).hasReadonlyFiles() || (document = file2.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner, false);
                ArrayList<XmlTag> tagsToProcess = new ArrayList<XmlTag>();
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className = StringUtil.unescapeXml((String)tag.getAttributeValue("name"));
                    if (!Comparing.strEqual((String)className, (String)externalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                        tagsToProcess.add(annotationTag);
                        processedAnything = true;
                    }
                }
                if (tagsToProcess.isEmpty()) continue;
                WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                    try {
                        for (XmlTag annotationTag : tagsToProcess) {
                            annotationTagProcessor.process((Object)annotationTag);
                        }
                        this.commitChanges(file2);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQN, processedAnything);
            boolean bl = processedAnything;
            return bl;
        }
        finally {
            this.dropCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        block15: {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!element.isPhysical()) {
                return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
            }
            if (!element.getManager().isInProject(element)) {
                return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
            }
            Project project2 = this.myPsiManager.getProject();
            if (CodeStyleSettingsManager.getSettings((Project)project2).USE_EXTERNAL_ANNOTATIONS) {
                MyExternalPromptDialog dialog2;
                PsiFile containingFile = element.getContainingFile();
                VirtualFile virtualFile = containingFile.getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                List entries = ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(virtualFile);
                if (!entries.isEmpty()) {
                    for (OrderEntry entry : entries) {
                        if (entry instanceof ModuleOrderEntry) continue;
                        if (AnnotationOrderRootType.getUrls(entry).length <= 0) break;
                        return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                    }
                }
                MyExternalPromptDialog myExternalPromptDialog = dialog2 = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MyExternalPromptDialog(project2);
                if (dialog2 != null && dialog2.isToBeShown()) {
                    PsiElement highlightElement = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : element.getNavigationElement();
                    LOG.assertTrue(highlightElement != null);
                    Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
                    ArrayList highlighters = new ArrayList();
                    boolean highlight = editor != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project2).getDocument(containingFile);
                    try {
                        ExternalAnnotationsManager.AnnotationPlace annotationPlace;
                        if (highlight) {
                            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                            TextRange textRange = highlightElement.getTextRange();
                            HighlightManager.getInstance((Project)project2).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, highlighters);
                            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
                            editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
                        }
                        dialog2.show();
                        if (dialog2.getExitCode() == 2) {
                            annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                            return annotationPlace;
                        }
                        if (dialog2.getExitCode() == 1) {
                            annotationPlace = ExternalAnnotationsManager.AnnotationPlace.NOWHERE;
                            return annotationPlace;
                        }
                        break block15;
                    }
                    finally {
                        if (highlight) {
                            HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(editor, (RangeHighlighter)highlighters.get(0));
                        }
                    }
                }
                if (dialog2 != null) {
                    dialog2.close(0);
                }
            }
        }
        return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    private void appendChosenAnnotationsRoot(@NotNull OrderEntry entry, @NotNull VirtualFile vFile) {
        if (entry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LOG.assertTrue(library != null);
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(vFile, AnnotationOrderRootType.getInstance());
            model.commit();
        } else if (entry instanceof ModuleSourceOrderEntry) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            JavaModuleExternalPaths extension = (JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class);
            extension.setExternalAnnotationUrls(ArrayUtil.mergeArrays((String[])extension.getExternalAnnotationsUrls(), (String[])new String[]{vFile.getUrl()}));
            model.commit();
        } else if (entry instanceof JdkOrderEntry) {
            SdkModificator sdkModificator = ((JdkOrderEntry)entry).getJdk().getSdkModificator();
            sdkModificator.addRoot(vFile, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @Nullable XmlFile xmlFile, @NotNull PsiFile codeUsageFile, @Nullable PsiNameValuePair[] values) {
        if (xmlFile == null) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        try {
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag rootTag = document.getRootTag();
                String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner, false);
                if (externalName == null) {
                    LOG.info("member without external name: " + listOwner);
                }
                if (rootTag != null && externalName != null) {
                    XmlTag anchor = null;
                    for (XmlTag item : rootTag.getSubTags()) {
                        int compare = Comparing.compare((Comparable)((Object)externalName), (Comparable)((Object)StringUtil.unescapeXml((String)item.getAttributeValue("name"))));
                        if (compare == 0) {
                            anchor = null;
                            for (XmlTag annotation : item.getSubTags()) {
                                compare = Comparing.compare((Comparable)((Object)annotationFQName), (Comparable)((Object)annotation.getAttributeValue("name")));
                                if (compare == 0) {
                                    annotation.delete();
                                    break;
                                }
                                anchor = annotation;
                            }
                            XmlTag newTag = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values));
                            item.addAfter((PsiElement)newTag, (PsiElement)anchor);
                            this.commitChanges(xmlFile);
                            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, true);
                            return;
                        }
                        if (compare < 0) break;
                        anchor = item;
                    }
                    String text = "<item name='" + StringUtil.escapeXml((String)externalName) + "'>\n";
                    text = text + ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values);
                    text = text + "</item>";
                    rootTag.addAfter((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)text), (PsiElement)anchor);
                    this.commitChanges(xmlFile);
                    this.notifyAfterAnnotationChanging(listOwner, annotationFQName, true);
                    return;
                }
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
        }
        finally {
            this.dropCache();
            if (codeUsageFile.getVirtualFile().isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)codeUsageFile);
            }
        }
    }

    private static void sortItems(@NotNull XmlFile xmlFile) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        ArrayList<XmlTag> itemTags = new ArrayList<XmlTag>();
        for (XmlTag item : rootTag.getSubTags()) {
            if (item.getAttributeValue("name") != null) {
                itemTags.add(item);
                continue;
            }
            item.delete();
        }
        ArrayList sorted = new ArrayList(itemTags);
        Collections.sort(sorted, (item1, item2) -> {
            String externalName1 = item1.getAttributeValue("name");
            String externalName2 = item2.getAttributeValue("name");
            assert (externalName1 != null && externalName2 != null);
            return externalName1.compareTo(externalName2);
        });
        if (!sorted.equals(itemTags)) {
            for (XmlTag item : sorted) {
                rootTag.addAfter((PsiElement)item, null);
                item.delete();
            }
        }
    }

    private void commitChanges(XmlFile xmlFile) {
        ExternalAnnotationsManagerImpl.sortItems(xmlFile);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document doc = documentManager.getDocument((PsiFile)xmlFile);
        assert (doc != null);
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        FileDocumentManager.getInstance().saveDocument(doc);
    }

    @NonNls
    @NotNull
    private static String createAnnotationTag(@NotNull String annotationFQName, @Nullable PsiNameValuePair[] values) {
        String text;
        if (values != null && values.length != 0) {
            text = "  <annotation name='" + annotationFQName + "'>\n";
            text = text + StringUtil.join((Object[])values, pair -> "<val" + (pair.getName() != null ? " name=\"" + pair.getName() + "\"" : "") + " val=\"" + StringUtil.escapeXml((String)pair.getValue().getText()) + "\"/>", (String)"    \n");
            text = text + "  </annotation>";
        } else {
            text = "  <annotation name='" + annotationFQName + "'/>\n";
        }
        return text;
    }

    @Nullable
    private XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName) {
        String[] dirs;
        for (String dir : dirs = packageName.split("[\\.]")) {
            if (dir.isEmpty()) break;
            VirtualFile subdir = root.findChild(dir);
            if (subdir == null) {
                try {
                    subdir = root.createChildDirectory(null, dir);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            root = subdir;
        }
        PsiDirectory directory = this.myPsiManager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        PsiFile psiFile = directory.findFile("annotations.xml");
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        try {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myPsiManager.getProject());
            return (XmlFile)directory.add((PsiElement)factory.createFileFromText("annotations.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"<root></root>"));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected void duplicateError(@NotNull PsiFile file2, @NotNull String externalName, @NotNull String text) {
        String message2 = text + "; for signature: '" + externalName + "' in the file " + file2.getVirtualFile().getPresentableUrl();
        LogMessageEx.error(LOG, message2, file2.getText());
    }

    public static boolean areExternalAnnotationsApplicable(@NotNull PsiModifierListOwner owner) {
        if (!owner.isPhysical()) {
            return false;
        }
        if (!owner.getManager().isInProject((PsiElement)owner)) {
            return true;
        }
        return CodeStyleSettingsManager.getSettings((Project)owner.getProject()).USE_EXTERNAL_ANNOTATIONS;
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        private void processEvent(VirtualFileEvent event) {
            if (event.isFromRefresh() && "annotations.xml".equals(event.getFileName())) {
                ExternalAnnotationsManagerImpl.this.dropCache();
                ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            this.processEvent(event);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            this.processEvent(event);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            this.processEvent(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            this.processEvent((VirtualFileEvent)event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            this.processEvent((VirtualFileEvent)event);
        }
    }

    private static class MyExternalPromptDialog
    extends OptionsMessageDialog {
        private final Project myProject;
        private static final String ADD_IN_CODE = ProjectBundle.message((String)"external.annotations.in.code.option", (Object[])new Object[0]);
        private static final String MESSAGE = ProjectBundle.message((String)"external.annotations.suggestion.message", (Object[])new Object[0]);

        MyExternalPromptDialog(Project project2) {
            super(project2, MESSAGE, ProjectBundle.message((String)"external.annotation.prompt", (Object[])new Object[0]), Messages.getQuestionIcon());
            this.myProject = project2;
            this.init();
        }

        protected String getOkActionName() {
            return ADD_IN_CODE;
        }

        @NotNull
        protected String getCancelActionName() {
            return CommonBundle.getCancelButtonText();
        }

        @NotNull
        protected Action[] createActions() {
            Action okAction = this.getOKAction();
            MyExternalPromptDialog.assignMnemonic((String)ADD_IN_CODE, (Action)okAction);
            final String externalName = ProjectBundle.message((String)"external.annotations.external.option", (Object[])new Object[0]);
            return new Action[]{okAction, new AbstractAction(externalName){
                {
                    super(x0);
                    MyExternalPromptDialog.assignMnemonic((String)externalName, (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.canBeHidden()) {
                        this.setToBeShown(this.toBeShown(), true);
                    }
                    this.close(2);
                }
            }, this.getCancelAction()};
        }

        protected boolean isToBeShown() {
            return CodeStyleSettingsManager.getSettings((Project)this.myProject).USE_EXTERNAL_ANNOTATIONS;
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            CodeStyleSettingsManager.getSettings((Project)this.myProject).USE_EXTERNAL_ANNOTATIONS = value2;
        }

        protected JComponent createNorthPanel() {
            JPanel northPanel = (JPanel)super.createNorthPanel();
            northPanel.add((Component)new JLabel(MESSAGE), "Center");
            return northPanel;
        }

        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }
    }
}

