/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return "Make Inferred Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        Object[] annotations2;
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner != null && owner.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) != null && PsiUtil.getLanguageLevel((PsiElement)file2).isAtLeast(LanguageLevel.JDK_1_5) && (annotations2 = InferredAnnotationsManager.getInstance((Project)project2).findInferredAnnotations(owner)).length > 0) {
            String annos = StringUtil.join((Object[])annotations2, annotation -> {
                PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
                String name = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner) {
        if (owner instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        assert (owner != null);
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        assert (module2 != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project2).findInferredAnnotations(owner)) {
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file2.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project2, Collections.singleton(module2), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(modifierList.addAfter((PsiElement)toInsert, null))));
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        Project project2 = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project2);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
        }
        return annotation;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

