/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityAnnotationModifier
extends TypeAnnotationModifier {
    @Nullable
    public TypeAnnotationProvider modifyAnnotations(@NotNull PsiType inferenceVariableType, @NotNull PsiClassType boundType) {
        PsiAnnotation[] annotations2;
        for (PsiAnnotation annotation : annotations2 = inferenceVariableType.getAnnotations()) {
            String qName = annotation.getQualifiedName();
            if (qName == null || !NullityAnnotationModifier.isMatchingAnnotation(boundType, annotation, qName)) continue;
            return NullityAnnotationModifier.removeAnnotation(annotations2, annotation);
        }
        return null;
    }

    @NotNull
    private static TypeAnnotationProvider removeAnnotation(PsiAnnotation[] annotations2, PsiAnnotation annotation) {
        ArrayList list = ContainerUtil.newArrayList((Object[])annotations2);
        list.remove(annotation);
        if (list.isEmpty()) {
            return TypeAnnotationProvider.EMPTY;
        }
        PsiAnnotation[] array = list.toArray(PsiAnnotation.EMPTY_ARRAY);
        return () -> array;
    }

    private static boolean isMatchingAnnotation(@NotNull PsiClassType boundType, PsiAnnotation annotation, String qName) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)annotation.getProject());
        return (manager.getNullables().contains(qName) || manager.getNotNulls().contains(qName)) && boundType.findAnnotation(qName) != null;
    }
}

