/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ToggleSourceInferredAnnotations
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return "Show/Hide Annotations Inferred from Source Code";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        boolean hasSrcInferredAnnotation;
        PsiElement leaf = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner != null && ExternalAnnotationsLineMarkerProvider.isSourceCode(owner) && (hasSrcInferredAnnotation = ContainerUtil.or(ExternalAnnotationsLineMarkerProvider.findSignatureNonCodeAnnotations(owner, true), annotation -> AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)))) {
            this.setText((CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS ? "Hide" : "Show") + " annotations inferred from source code");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS = !CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS;
        DaemonCodeAnalyzer.getInstance((Project)project2).restart(file2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

