/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileInEditorProcessor {
    private static final Logger LOG = Logger.getInstance(FileInEditorProcessor.class);
    private final Editor myEditor;
    private boolean myNoChangesDetected = false;
    private final boolean myProcessChangesTextOnly;
    private final boolean myShouldOptimizeImports;
    private final boolean myShouldRearrangeCode;
    private final boolean myProcessSelectedText;
    private final Project myProject;
    private final PsiFile myFile;
    private AbstractLayoutCodeProcessor myProcessor;

    public FileInEditorProcessor(PsiFile file2, Editor editor, LayoutCodeOptions runOptions) {
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myEditor = editor;
        this.myShouldOptimizeImports = runOptions.isOptimizeImports();
        this.myShouldRearrangeCode = runOptions.isRearrangeCode();
        this.myProcessSelectedText = this.myEditor != null && runOptions.getTextRangeType() == TextRangeType.SELECTED_TEXT;
        this.myProcessChangesTextOnly = runOptions.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
    }

    public void processCode() {
        if (this.myShouldOptimizeImports) {
            this.myProcessor = new OptimizeImportsProcessor(this.myProject, this.myFile);
        }
        if (this.myProcessChangesTextOnly && !FormatChangedTextUtil.hasChanges(this.myFile)) {
            this.myNoChangesDetected = true;
        }
        this.myProcessor = this.mixWithReformatProcessor(this.myProcessor);
        if (this.myShouldRearrangeCode) {
            this.myProcessor = this.mixWithRearrangeProcessor(this.myProcessor);
        }
        if (this.shouldNotify()) {
            this.myProcessor.setCollectInfo(true);
            this.myProcessor.setPostRunnable(() -> {
                String message2 = this.prepareMessage();
                if (!this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                    HyperlinkAdapter hyperlinkListener = new HyperlinkAdapter(){

                        protected void hyperlinkActivated(HyperlinkEvent e) {
                            AnAction action = ActionManager.getInstance().getAction("ShowReformatFileDialog");
                            DataManager manager = DataManager.getInstance();
                            if (manager != null) {
                                DataContext context = manager.getDataContext((Component)FileInEditorProcessor.this.myEditor.getContentComponent());
                                action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context));
                            }
                        }
                    };
                    FileInEditorProcessor.showHint(this.myEditor, message2, (HyperlinkListener)hyperlinkListener);
                }
            });
        }
        this.myProcessor.run();
    }

    private AbstractLayoutCodeProcessor mixWithRearrangeProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        processor2 = this.myProcessSelectedText ? new RearrangeCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new RearrangeCodeProcessor(processor2);
        return processor2;
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithReformatProcessor(@Nullable AbstractLayoutCodeProcessor processor2) {
        processor2 = processor2 != null ? (this.myProcessSelectedText ? new ReformatCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(processor2, this.myProcessChangesTextOnly)) : (this.myProcessSelectedText ? new ReformatCodeProcessor(this.myFile, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(this.myFile, this.myProcessChangesTextOnly));
        return processor2;
    }

    @NotNull
    private String prepareMessage() {
        StringBuilder builder = new StringBuilder("<html>");
        LayoutCodeInfoCollector notifications = this.myProcessor.getInfoCollector();
        LOG.assertTrue(notifications != null);
        if (notifications.isEmpty() && !this.myNoChangesDetected) {
            if (this.myProcessChangesTextOnly) {
                builder.append("No lines changed: changes since last revision are already properly formatted").append("<br>");
            } else {
                builder.append("No lines changed: content is already properly formatted").append("<br>");
            }
        } else {
            if (notifications.hasReformatOrRearrangeNotification()) {
                String reformatInfo = notifications.getReformatCodeNotification();
                String rearrangeInfo = notifications.getRearrangeCodeNotification();
                builder.append(FileInEditorProcessor.joinWithCommaAndCapitalize(reformatInfo, rearrangeInfo));
                if (this.myProcessChangesTextOnly) {
                    builder.append(" in changes since last revision");
                }
                builder.append("<br>");
            } else if (this.myNoChangesDetected) {
                builder.append("No lines changed: no changes since last revision").append("<br>");
            }
            String optimizeImportsNotification = notifications.getOptimizeImportsNotification();
            if (optimizeImportsNotification != null) {
                builder.append(StringUtil.capitalize((String)optimizeImportsNotification)).append("<br>");
            }
        }
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowReformatFileDialog"));
        String color = ColorUtil.toHex((Color)JBColor.gray);
        builder.append("<span style='color:#").append(color).append("'>").append("<a href=''>Show</a> reformat dialog: ").append(shortcutText).append("</span>").append("</html>");
        return builder.toString();
    }

    @NotNull
    private static String joinWithCommaAndCapitalize(String reformatNotification, String rearrangeNotification) {
        String firstNotificationLine;
        String string = firstNotificationLine = reformatNotification != null ? reformatNotification : rearrangeNotification;
        if (reformatNotification != null && rearrangeNotification != null) {
            firstNotificationLine = firstNotificationLine + ", " + rearrangeNotification;
        }
        firstNotificationLine = StringUtil.capitalize((String)firstNotificationLine);
        return firstNotificationLine;
    }

    private static boolean isCaretVisible(Editor editor) {
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Caret currentCaret = editor.getCaretModel().getCurrentCaret();
        Point caretPoint = editor.visualPositionToXY(currentCaret.getVisualPosition());
        return visibleArea.contains(caretPoint);
    }

    public static void showHint(@NotNull Editor editor, @NotNull String info, @Nullable HyperlinkListener hyperlinkListener) {
        JComponent component = HintUtil.createInformationLabel(info, hyperlinkListener, null, null);
        LightweightHint hint = new LightweightHint(component);
        int flags = 42;
        if (FileInEditorProcessor.isCaretVisible(editor)) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, flags, 0, false);
        } else {
            FileInEditorProcessor.showHintWithoutScroll(editor, hint, flags);
        }
    }

    private static void showHintWithoutScroll(Editor editor, LightweightHint hint, int flags) {
        short constraint;
        int y;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (FileInEditorProcessor.isCaretAboveTop(editor, visibleArea)) {
            y = visibleArea.y;
            constraint = 2;
        } else {
            y = visibleArea.y + visibleArea.height;
            constraint = 1;
        }
        Point hintPoint = new Point(visibleArea.x + visibleArea.width / 2, y);
        JComponent component = HintManagerImpl.getExternalComponent(editor);
        Point convertedPoint = SwingUtilities.convertPoint(editor.getContentComponent(), hintPoint, component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, convertedPoint, flags, 0, false, constraint);
    }

    private static boolean isCaretAboveTop(Editor editor, Rectangle area) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        VisualPosition caretVisualPosition = caret.getVisualPosition();
        int caretY = editor.visualPositionToXY((VisualPosition)caretVisualPosition).y;
        return caretY < area.y;
    }

    private boolean shouldNotify() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return false;
        }
        EditorSettingsExternalizable.OptionSet editorOptions = EditorSettingsExternalizable.getInstance().getOptions();
        return editorOptions.SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION && this.myEditor != null && !this.myProcessSelectedText;
    }
}

