/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    private final Collection<TextRange> myRanges = new ArrayList<TextRange>();
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project2, boolean processChangedTextOnly) {
        super(project2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, Module module2, boolean processChangedTextOnly) {
        super(project2, module2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project2, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile file2, @Nullable TextRange range, boolean processChangedTextOnly) {
        super(project2, file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        if (range != null) {
            this.myRanges.add(range);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project2, files, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        return new FutureTask<Boolean>(() -> {
            FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
            try {
                CharSequence before = null;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
                if (this.getInfoCollector() != null) {
                    LOG.assertTrue(document != null);
                    before = document.getImmutableCharSequence();
                }
                CaretVisualPositionKeeper caretPositionKeeper = new CaretVisualPositionKeeper(document);
                if (processChangedTextOnly) {
                    ChangedRangesInfo info = FormatChangedTextUtil.getInstance().getChangedRangesInfo(file2);
                    if (info != null) {
                        CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(file2, info);
                    }
                } else {
                    Collection<TextRange> ranges = this.getRangesToFormat(file2);
                    CodeStyleManager.getInstance((Project)this.myProject).reformatText(file2, ranges);
                }
                caretPositionKeeper.restoreOriginalLocation();
                if (before != null) {
                    this.prepareUserNotificationMessage(document, before);
                }
                Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                return bl;
            }
            catch (FilesTooBigForDiffException e) {
                this.handleFileTooBigException(LOG, e, file2);
                Boolean bl = false;
                return bl;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.myRanges.clear();
            }
        });
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message2 = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message2);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            return ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        return !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
    }
}

