/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;

public class AbstractExpectedTypeSkipper
extends CompletionPreselectSkipper {
    public boolean skipElement(LookupElement element, CompletionLocation location) {
        return AbstractExpectedTypeSkipper.skips(element, location);
    }

    public static boolean skips(LookupElement element, CompletionLocation location) {
        return AbstractExpectedTypeSkipper.getSkippingStatus(element, location) != Result.ACCEPT;
    }

    private static Result getSkippingStatus(LookupElement item, CompletionLocation location) {
        if (location.getCompletionType() != CompletionType.SMART) {
            return Result.ACCEPT;
        }
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)location.getCompletionParameters().getPosition(), PsiExpression.class);
        if (!(expression2 instanceof PsiNewExpression)) {
            return Result.ACCEPT;
        }
        Object object = item.getObject();
        if (!(object instanceof PsiClass)) {
            return Result.ACCEPT;
        }
        if (StatisticsManager.getInstance().getUseCount(StatisticsWeigher.getBaseStatisticsInfo(item, location)) > 1) {
            return Result.ACCEPT;
        }
        PsiClass psiClass = (PsiClass)object;
        int toImplement = 0;
        for (PsiMethod method2 : psiClass.getMethods()) {
            if (!method2.hasModifierProperty("abstract") || ++toImplement <= 2) continue;
            return Result.ABSTRACT;
        }
        if ((toImplement += OverrideImplementUtil.getMethodSignaturesToImplement(psiClass).size()) > 2) {
            return Result.ABSTRACT;
        }
        ExpectedTypeInfo[] infos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
        boolean isDefaultType = false;
        if (infos != null) {
            PsiClassType type2 = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
            for (ExpectedTypeInfo info : infos) {
                PsiType infoType = TypeConversionUtil.erasure((PsiType)info.getType().getDeepComponentType());
                PsiType defaultType = TypeConversionUtil.erasure((PsiType)info.getDefaultType().getDeepComponentType());
                if (defaultType.equals(infoType) || !infoType.isAssignableFrom((PsiType)type2)) continue;
                if (!defaultType.isAssignableFrom((PsiType)type2)) {
                    return Result.NON_DEFAULT;
                }
                isDefaultType = true;
            }
        }
        if (toImplement > 0) {
            return Result.ACCEPT;
        }
        if (psiClass.hasModifierProperty("abstract")) {
            return Result.ABSTRACT;
        }
        if (!isDefaultType && "java.lang.String".equals(psiClass.getQualifiedName())) {
            return Result.STRING;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return Result.NON_DEFAULT;
        }
        return Result.ACCEPT;
    }

    private static enum Result {
        NON_DEFAULT,
        STRING,
        ABSTRACT,
        ACCEPT;

    }
}

