/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionTemplateItem;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.KeywordLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInsight.template.SmartCompletionContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.getters.ClassLiteralGetter;
import com.intellij.psi.filters.getters.ThisGetter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicExpressionCompletionContributor {
    private static void addKeyword(Consumer<LookupElement> result2, PsiElement element, String s) {
        result2.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(element, s));
    }

    public static LookupElement createKeywordLookupItem(PsiElement element, String s) {
        return new KeywordLookupItem(JavaPsiFacade.getElementFactory((Project)element.getProject()).createKeyword(s, element), element);
    }

    public static void fillCompletionVariants(JavaSmartCompletionParameters parameters2, Consumer<LookupElement> result2, PrefixMatcher matcher) {
        PsiElement element = parameters2.getPosition();
        if (JavaKeywordCompletion.isAfterTypeDot(element)) {
            BasicExpressionCompletionContributor.addKeyword(result2, element, "class");
            BasicExpressionCompletionContributor.addKeyword(result2, element, "this");
        }
        if (!JavaKeywordCompletion.AFTER_DOT.accepts((Object)element)) {
            if (parameters2.getParameters().getInvocationCount() <= 1) {
                new CollectionsUtilityMethodsProvider(parameters2.getPosition(), parameters2.getExpectedType(), parameters2.getDefaultType(), result2).addCompletions(StringUtil.isNotEmpty((String)matcher.getPrefix()));
            }
            ClassLiteralGetter.addCompletions(parameters2, result2, matcher);
            PsiElement position = parameters2.getPosition();
            PsiType expectedType = parameters2.getExpectedType();
            for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
                if (template.isDeactivated() || !template.getTemplateContext().isEnabled(new SmartCompletionContextType())) continue;
                result2.consume((Object)new SmartCompletionTemplateItem(template, position));
            }
            BasicExpressionCompletionContributor.addKeyword(result2, position, "true");
            BasicExpressionCompletionContributor.addKeyword(result2, position, "false");
            PsiElement parent = position.getParent();
            if (parent != null && !(parent.getParent() instanceof PsiSwitchLabelStatement)) {
                for (PsiExpression expression2 : ThisGetter.getThisExpressionVariants(position)) {
                    result2.consume((Object)new ExpressionLookupItem(expression2));
                }
            }
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(position, expectedType, matcher, result2);
        }
    }

    public static void processDataflowExpressionTypes(PsiElement position, @Nullable PsiType expectedType, final PrefixMatcher matcher, Consumer<LookupElement> consumer2) {
        PsiExpression context = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpression.class);
        if (context == null) {
            return;
        }
        final Map<PsiExpression, PsiType> map2 = GuessManager.getInstance(position.getProject()).getControlFlowExpressionTypes(context);
        if (map2.isEmpty()) {
            return;
        }
        PsiScopesUtil.treeWalkUp(new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element instanceof PsiLocalVariable) {
                    PsiType dfaCasted;
                    PsiTypeCastExpression typeCastExpression;
                    PsiExpression operand2;
                    if (!matcher.prefixMatches(((PsiLocalVariable)element).getName())) {
                        return true;
                    }
                    PsiExpression expression2 = ((PsiLocalVariable)element).getInitializer();
                    if (expression2 instanceof PsiTypeCastExpression && (operand2 = (typeCastExpression = (PsiTypeCastExpression)expression2).getOperand()) != null && (dfaCasted = (PsiType)map2.get(operand2)) != null && dfaCasted.equals(typeCastExpression.getType())) {
                        map2.remove(operand2);
                    }
                }
                return true;
            }
        }, (PsiElement)context, (PsiElement)context.getContainingFile());
        for (PsiExpression expression2 : map2.keySet()) {
            PsiType castType = map2.get(expression2);
            PsiType baseType = expression2.getType();
            if (expectedType != null && (!expectedType.isAssignableFrom(castType) || baseType != null && expectedType.isAssignableFrom(baseType))) continue;
            consumer2.consume((Object)CastingLookupElementDecorator.createCastingElement(BasicExpressionCompletionContributor.expressionToLookupElement(expression2), castType));
        }
    }

    @NotNull
    private static LookupElement expressionToLookupElement(@NotNull PsiExpression expression2) {
        PsiMethod method2;
        PsiMethodCallExpression call;
        PsiElement target;
        PsiReferenceExpression refExpr;
        if (expression2 instanceof PsiReferenceExpression && !(refExpr = (PsiReferenceExpression)expression2).isQualified() && (target = refExpr.resolve()) instanceof PsiVariable) {
            VariableLookupItem item = new VariableLookupItem((PsiVariable)target);
            item.setSubstitutor(PsiSubstitutor.EMPTY);
            return item;
        }
        if (expression2 instanceof PsiMethodCallExpression && !(call = (PsiMethodCallExpression)expression2).getMethodExpression().isQualified() && (method2 = call.resolveMethod()) != null) {
            return new JavaMethodCallElement(method2);
        }
        return new ExpressionLookupItem(expression2);
    }
}

