/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionPhase
implements Disposable {
    public static final CompletionPhase NoCompletion = new CompletionPhase(null){

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }
    };
    public final CompletionProgressIndicator indicator;

    protected CompletionPhase(@Nullable CompletionProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public void dispose() {
    }

    public abstract int newCompletionStarted(int var1, boolean var2);

    public boolean fillInCommonPrefix() {
        return false;
    }

    public static class NoSuggestionsHint
    extends ZombiePhase {
        public NoSuggestionsHint(@Nullable LightweightHint hint, CompletionProgressIndicator indicator) {
            super(hint, indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class InsertedSingleItem
    extends ZombiePhase {
        public final Runnable restorePrefix;

        public InsertedSingleItem(CompletionProgressIndicator indicator, Runnable restorePrefix) {
            super(null, indicator);
            this.restorePrefix = restorePrefix;
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            this.indicator.restorePrefix(this.restorePrefix);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static abstract class ZombiePhase
    extends CompletionPhase {
        protected ZombiePhase(final @Nullable LightweightHint hint, CompletionProgressIndicator indicator) {
            super(indicator);
            Editor editor = indicator.getEditor();
            final HintListener hintListener = new HintListener(){

                @Override
                public void hintHidden(EventObject event) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            };
            final DocumentAdapter documentListener = new DocumentAdapter(){

                public void beforeDocumentChange(DocumentEvent e) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            };
            final SelectionListener selectionListener = new SelectionListener(){

                public void selectionChanged(SelectionEvent e) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            };
            CaretAdapter caretListener = new CaretAdapter(){

                public void caretPositionChanged(CaretEvent e) {
                    CompletionServiceImpl.setCompletionPhase(NoCompletion);
                }
            };
            final Document document = editor.getDocument();
            final SelectionModel selectionModel = editor.getSelectionModel();
            final CaretModel caretModel = editor.getCaretModel();
            if (hint != null) {
                hint.addHintListener(hintListener);
            }
            document.addDocumentListener((DocumentListener)documentListener);
            selectionModel.addSelectionListener(selectionListener);
            caretModel.addCaretListener((CaretListener)caretListener);
            Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener){
                final /* synthetic */ CaretListener val$caretListener;
                {
                    this.val$caretListener = caretListener;
                }

                public void dispose() {
                    if (hint != null) {
                        hint.removeHintListener(hintListener);
                    }
                    document.removeDocumentListener((DocumentListener)documentListener);
                    selectionModel.removeSelectionListener(selectionListener);
                    caretModel.removeCaretListener(this.val$caretListener);
                }
            });
        }
    }

    public static class ItemsCalculated
    extends CompletionPhase {
        public ItemsCalculated(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            this.indicator.restorePrefix(() -> this.indicator.getLookup().restorePrefix());
            return this.indicator.nextInvocationCount(time, repeated);
        }

        @Override
        public boolean fillInCommonPrefix() {
            if (this.indicator.isAutopopupCompletion()) {
                return false;
            }
            return this.indicator.fillInCommonPrefix(true);
        }
    }

    public static class BgCalculation
    extends CompletionPhase {
        boolean modifiersChanged = false;

        public BgCalculation(final CompletionProgressIndicator indicator) {
            super(indicator);
            ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (!indicator.getLookup().isLookupDisposed() && !indicator.isCanceled()) {
                        indicator.scheduleRestart();
                    }
                }
            }, (Disposable)this);
            if (indicator.isAutopopupCompletion()) {
                ((EditorEx)indicator.getEditor()).addFocusListener(new FocusChangeListener(){

                    @Override
                    public void focusGained(Editor editor) {
                    }

                    @Override
                    public void focusLost(Editor editor) {
                        indicator.closeAndFinish(true);
                    }
                }, this);
            }
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            this.indicator.closeAndFinish(false);
            return this.indicator.nextInvocationCount(time, repeated);
        }
    }

    public static class Synchronous
    extends CompletionPhase {
        public Synchronous(CompletionProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            CompletionServiceImpl.assertPhase(NoCompletion.getClass());
            CompletionServiceImpl.setCompletionPhase(NoCompletion);
            return time;
        }
    }

    public static class CommittingDocuments
    extends CompletionPhase {
        boolean replaced;
        private final ActionTracker myTracker;

        public CommittingDocuments(@Nullable CompletionProgressIndicator prevIndicator, Editor editor) {
            super(prevIndicator);
            this.myTracker = new ActionTracker(editor, this);
        }

        public void ignoreCurrentDocumentChange() {
            this.myTracker.ignoreCurrentDocumentChange();
        }

        public boolean isRestartingCompletion() {
            return this.indicator != null;
        }

        public boolean checkExpired() {
            if (CompletionServiceImpl.getCompletionPhase() != this) {
                return true;
            }
            if (this.myTracker.hasAnythingHappened() || ApplicationManager.getApplication().isWriteAccessAllowed()) {
                CompletionServiceImpl.setCompletionPhase(NoCompletion);
                return true;
            }
            return false;
        }

        @Override
        public int newCompletionStarted(int time, boolean repeated) {
            return time;
        }

        @Override
        public void dispose() {
            if (!this.replaced && this.indicator != null) {
                this.indicator.closeAndFinish(true);
            }
        }

        public String toString() {
            return "CommittingDocuments{hasIndicator=" + (this.indicator != null) + '}';
        }
    }
}

