/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeCompletionContributor
extends CompletionContributor
implements DumbAware {
    public CustomFileTypeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withFileType((ElementPattern)StandardPatterns.instanceOf(CustomSyntaxTableFileType.class))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (CustomFileTypeCompletionContributor.inCommentOrLiteral(parameters2)) {
                    return;
                }
                FileType fileType = parameters2.getOriginalFile().getFileType();
                if (!(fileType instanceof CustomSyntaxTableFileType)) {
                    return;
                }
                SyntaxTable syntaxTable = ((CustomSyntaxTableFileType)fileType).getSyntaxTable();
                String prefix = CustomFileTypeCompletionContributor.findPrefix(parameters2.getPosition(), parameters2.getOffset());
                CompletionResultSet resultSetWithPrefix = result2.withPrefixMatcher(prefix);
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords1());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords2());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords3());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords4());
                WordCompletionContributor.addWordCompletionVariants(resultSetWithPrefix, parameters2, Collections.emptySet());
            }
        });
    }

    private static boolean inCommentOrLiteral(CompletionParameters parameters2) {
        HighlighterIterator iterator = ((EditorEx)parameters2.getEditor()).getHighlighter().createIterator(parameters2.getOffset());
        if (iterator.atEnd()) {
            return false;
        }
        IElementType elementType = iterator.getTokenType();
        if (elementType == CustomHighlighterTokenType.WHITESPACE) {
            iterator.retreat();
            elementType = iterator.getTokenType();
        }
        return elementType == CustomHighlighterTokenType.LINE_COMMENT || elementType == CustomHighlighterTokenType.MULTI_LINE_COMMENT || elementType == CustomHighlighterTokenType.STRING || elementType == CustomHighlighterTokenType.SINGLE_QUOTED_STRING;
    }

    private static void addVariants(CompletionResultSet resultSet, Set<String> keywords) {
        for (String keyword : keywords) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
        }
    }

    private static String findPrefix(PsiElement insertedElement, int offset) {
        int start;
        String text = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextOffset();
        for (start = offsetInElement - 1; start >= 0 && Character.isJavaIdentifierStart(text.charAt(start)); --start) {
        }
        return text.substring(start + 1, offsetInElement).trim();
    }
}

