/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.AnnotationInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class ExpectedAnnotationsProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_VALUE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withSuperParent(2, PsiNameValuePair.class)});

    ExpectedAnnotationsProvider() {
    }

    public void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement element = parameters2.getPosition();
        for (PsiType type2 : ExpectedTypesGetter.getExpectedTypes(element, false)) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (psiClass == null || !psiClass.isAnnotationType()) continue;
            result2.addElement((LookupElement)AllClassesGetter.createLookupItem(psiClass, AnnotationInsertHandler.INSTANCE));
        }
    }
}

