/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlCompletionContributor
extends CompletionContributor {
    public HtmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position = parameters2.getPosition();
                if (!HtmlCompletionContributor.hasHtmlAttributesCompletion(position)) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue != null && attributeValue.getParent() instanceof XmlAttribute) {
                    for (String element : HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)attributeValue.getParent())) {
                        result2.addElement((LookupElement)LookupElementBuilder.create((String)element));
                    }
                }
            }
        });
    }

    private static boolean hasHtmlAttributesCompletion(PsiElement position) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, HtmlTag.class, (boolean)false) != null) {
            return true;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)position, XmlTag.class, (boolean)false);
        return xmlTag != null && xmlTag.getLanguage() == XHTMLLanguage.INSTANCE;
    }

    @NotNull
    @NonNls
    protected static String[] addSpecificCompletions(XmlAttribute attribute) {
        String namespace;
        String name = attribute.getName();
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String tagName = tag.getName();
        if (tag.getDescriptor() instanceof HtmlElementDescriptorImpl) {
            name = name.toLowerCase();
            tagName = tagName.toLowerCase();
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace = tag.getNamespace()) || "http://www.w3.org/1999/html".equals(namespace)) {
            if ("target".equals(name)) {
                return new String[]{"_blank", "_top", "_self", "_parent"};
            }
            if ("enctype".equals(name)) {
                return new String[]{"multipart/form-data", "application/x-www-form-urlencoded"};
            }
            if ("rel".equals(name) || "rev".equals(name)) {
                return new String[]{"alternate", "author", "bookmark", "help", "icon", "license", "next", "nofollow", "noreferrer", "prefetch", "prev", "search", "stylesheet", "tag", "start", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "script", "import", "apple-touch-icon", "apple-touch-icon-precomposed", "apple-touch-startup-image"};
            }
            if ("media".equals(name)) {
                return new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
            }
            if ("language".equals(name)) {
                return new String[]{"JavaScript", "VBScript", "JScript", "JavaScript1.2", "JavaScript1.3", "JavaScript1.4", "JavaScript1.5"};
            }
            if ("type".equals(name) && "link".equals(tagName)) {
                return new String[]{"text/css", "text/html", "text/plain", "text/xml"};
            }
            if ("http-equiv".equals(name) && "meta".equals(tagName)) {
                return HtmlUtil.RFC2616_HEADERS;
            }
            if ("content".equals(name) && "meta".equals(tagName) && tag.getAttribute("name") == null) {
                return HtmlUtil.CONTENT_TYPES;
            }
            if ("accept".equals(name) && "input".equals(tagName)) {
                return HtmlUtil.CONTENT_TYPES;
            }
            if ("accept-charset".equals(name) || "charset".equals(name)) {
                Charset[] charSets = CharsetToolkit.getAvailableCharsets();
                String[] names = new String[charSets.length];
                for (int i2 = 0; i2 < names.length; ++i2) {
                    names[i2] = charSets[i2].toString();
                }
                return names;
            }
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }
}

