/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession
implements Consumer<LookupElement> {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private Set<String> myKeywords = new HashSet<String>();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result2) {
        this.myResult = result2;
    }

    public void consume(LookupElement lookupElement) {
        PsiClass psiClass = JavaCompletionSession.extractClass(lookupElement);
        if (psiClass != null) {
            this.registerClass(psiClass);
        }
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    @Nullable
    private static PsiClass extractClass(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            return (PsiClass)object;
        }
        if (object instanceof PsiMethod && ((PsiMethod)object).isConstructor()) {
            return ((PsiMethod)object).getContainingClass();
        }
        return null;
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        String name = psiClass.getQualifiedName();
        return name == null ? psiClass.getName() : name;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        PsiClass psiClass = JavaCompletionSession.extractClass(element);
        return psiClass != null && this.alreadyProcessed(psiClass);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        String name = JavaCompletionSession.getClassName(object);
        return name == null || this.myAddedClasses.contains(name);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        return this.myKeywords.contains(keyword);
    }

    public void registerKeyword(@NotNull String keyword) {
        this.myKeywords.add(keyword);
    }
}

