/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class JavaModuleCompletion {
    private static final Predicate<PsiClass> SERVICE_FILTER = psiClass -> !psiClass.isEnum() && psiClass.hasModifierProperty("public");
    private static final InsertHandler<LookupElement> FQN_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            String fqn;
            Object e = item.getObject();
            String string = fqn = e instanceof PsiClass ? ((PsiClass)e).getQualifiedName() : ((PsiQualifiedNamedElement)e).getQualifiedName();
            if (fqn != null) {
                int start = JavaCompletionUtil.findQualifiedNameStart(context);
                context.getDocument().replaceString(start, context.getTailOffset(), (CharSequence)fqn);
            }
        }
    };

    JavaModuleCompletion() {
    }

    static boolean isModuleFile(@NotNull PsiFile file2) {
        return "module-info.java".equals(file2.getName()) && PsiUtil.isLanguageLevel9OrHigher((PsiElement)file2);
    }

    static void addVariants(@NotNull PsiElement position, @NotNull CompletionResultSet resultSet) {
        Consumer result2 = element -> {
            if (element.getLookupString().startsWith(resultSet.getPrefixMatcher().getPrefix())) {
                resultSet.addElement(element);
            }
        };
        if (position instanceof PsiIdentifier) {
            PsiElement context = position.getParent();
            if (context instanceof PsiErrorElement) {
                context = context.getParent();
            }
            if (context instanceof PsiJavaFile) {
                JavaModuleCompletion.addFileHeaderKeywords(position, (Consumer<LookupElement>)result2);
            } else if (context instanceof PsiJavaModule) {
                JavaModuleCompletion.addModuleStatementKeywords(position, (Consumer<LookupElement>)result2);
            } else if (context instanceof PsiProvidesStatement) {
                JavaModuleCompletion.addProvidesStatementKeywords(position, (Consumer<LookupElement>)result2);
            } else if (context instanceof PsiJavaModuleReferenceElement) {
                JavaModuleCompletion.addRequiresStatementKeywords(context, position, (Consumer<LookupElement>)result2);
                JavaModuleCompletion.addModuleReferences(context, (Consumer<LookupElement>)result2);
            } else if (context instanceof PsiJavaCodeReferenceElement) {
                JavaModuleCompletion.addClassOrPackageReferences(context, (Consumer<LookupElement>)result2, resultSet);
            }
        }
    }

    private static void addFileHeaderKeywords(PsiElement position, Consumer<LookupElement> result2) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "module"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "open"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        } else if (PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.OPEN_KEYWORD)) {
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "module"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static void addModuleStatementKeywords(PsiElement position, Consumer<LookupElement> result2) {
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "requires"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "exports"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "opens"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "uses"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "provides"), TailType.HUMBLE_SPACE_BEFORE_WORD));
    }

    private static void addProvidesStatementKeywords(PsiElement position, Consumer<LookupElement> result2) {
        result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "with"), TailType.HUMBLE_SPACE_BEFORE_WORD));
    }

    private static void addRequiresStatementKeywords(PsiElement context, PsiElement position, Consumer<LookupElement> result2) {
        if (context.getParent() instanceof PsiRequiresStatement) {
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "transitive"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace(JavaKeywordCompletion.createKeyword(position, "static"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static void addModuleReferences(PsiElement context, Consumer<LookupElement> result2) {
        PsiElement host;
        PsiElement statement2 = context.getParent();
        if (!(statement2 instanceof PsiJavaModule) && (host = statement2.getParent()) instanceof PsiJavaModule) {
            String hostName = ((PsiJavaModule)host).getName();
            Project project2 = context.getProject();
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            GlobalSearchScope scope = ProjectScope.getAllScope((Project)project2);
            THashSet candidateNames = new THashSet();
            index.processAllKeys(project2, arg_0 -> JavaModuleCompletion.lambda$addModuleReferences$1(hostName, (Set)candidateNames, arg_0));
            for (String candidateName : candidateNames) {
                if (index.get(candidateName, project2, scope).size() != 1) continue;
                result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace((LookupElement)LookupElementBuilder.create((String)candidateName), TailType.SEMICOLON));
            }
        }
    }

    private static void addClassOrPackageReferences(PsiElement context, Consumer<LookupElement> result2, CompletionResultSet resultSet) {
        PsiJavaCodeReferenceElement intRef;
        PsiElement statement2;
        PsiElement refOwner = context.getParent();
        if (refOwner instanceof PsiPackageAccessibilityStatement) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            PsiPackage topPackage = JavaPsiFacade.getInstance((Project)context.getProject()).findPackage("");
            if (module2 != null && topPackage != null) {
                JavaModuleCompletion.processPackage(topPackage, module2.getModuleScope(false), result2);
            }
        } else if (refOwner instanceof PsiUsesStatement) {
            JavaModuleCompletion.processClasses(context.getProject(), null, resultSet, SERVICE_FILTER, TailType.SEMICOLON);
        } else if (refOwner instanceof PsiProvidesStatement) {
            JavaModuleCompletion.processClasses(context.getProject(), null, resultSet, SERVICE_FILTER, TailType.HUMBLE_SPACE_BEFORE_WORD);
        } else if (refOwner instanceof PsiReferenceList && (statement2 = refOwner.getParent()) instanceof PsiProvidesStatement && (intRef = ((PsiProvidesStatement)statement2).getInterfaceReference()) != null) {
            PsiElement service = intRef.resolve();
            Module module3 = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            if (service instanceof PsiClass && module3 != null) {
                Predicate<PsiClass> filter = psiClass -> !psiClass.hasModifierProperty("abstract") && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)((PsiClass)service), (boolean)true);
                JavaModuleCompletion.processClasses(context.getProject(), module3.getModuleScope(false), resultSet, filter, TailType.SEMICOLON);
            }
        }
    }

    private static void processPackage(PsiPackage pkg, GlobalSearchScope scope, Consumer<LookupElement> result2) {
        String packageName = pkg.getQualifiedName();
        if (JavaModuleCompletion.isQualified(packageName) && !PsiUtil.isPackageEmpty((PsiDirectory[])pkg.getDirectories(scope), (String)packageName)) {
            result2.consume((Object)new JavaKeywordCompletion.OverrideableSpace((LookupElement)JavaModuleCompletion.lookupElement((PsiNamedElement)pkg), TailType.SEMICOLON));
        }
        for (PsiPackage subPackage : pkg.getSubPackages(scope)) {
            JavaModuleCompletion.processPackage(subPackage, scope, result2);
        }
    }

    private static void processClasses(Project project2, GlobalSearchScope scope, CompletionResultSet resultSet, Predicate<PsiClass> filter, TailType tail) {
        GlobalSearchScope _scope = scope != null ? scope : ProjectScope.getAllScope((Project)project2);
        AllClassesGetter.processJavaClasses(resultSet.getPrefixMatcher(), project2, _scope, (Processor<PsiClass>)((Processor)psiClass -> {
            if (JavaModuleCompletion.isQualified(psiClass.getQualifiedName()) && filter.test((PsiClass)psiClass)) {
                resultSet.addElement((LookupElement)new JavaKeywordCompletion.OverrideableSpace((LookupElement)JavaModuleCompletion.lookupElement((PsiNamedElement)psiClass), tail));
            }
            return true;
        }));
    }

    private static LookupElementBuilder lookupElement(PsiNamedElement e) {
        LookupElementBuilder lookup = LookupElementBuilder.create((PsiNamedElement)e).withInsertHandler(FQN_INSERT_HANDLER);
        String fqn = e instanceof PsiClass ? ((PsiClass)e).getQualifiedName() : ((PsiQualifiedNamedElement)e).getQualifiedName();
        return fqn != null ? lookup.withPresentableText(fqn) : lookup;
    }

    private static boolean isQualified(String name) {
        return name != null && name.indexOf(46) > 0;
    }

    private static /* synthetic */ boolean lambda$addModuleReferences$1(String hostName, Set candidateNames, String name) {
        if (!name.equals(hostName)) {
            candidateNames.add(name);
        }
        return true;
    }
}

