/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.PairConsumer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LegacyCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.LegacyCompletionContributor");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters2);
        if (completionData == null) {
            return;
        }
        PsiElement insertedElement = parameters2.getPosition();
        CompletionResultSet result2 = _result.withPrefixMatcher(completionData.findPrefix(insertedElement, parameters2.getOffset()));
        LegacyCompletionContributor.completeReference(parameters2, result2);
        LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
        HashSet<CompletionVariant> keywordVariants = new HashSet<CompletionVariant>();
        PsiFile file2 = parameters2.getOriginalFile();
        completionData.addKeywordVariants(keywordVariants, insertedElement, file2);
        completionData.completeKeywordsBySet(lookupSet, keywordVariants);
        result2.addAllElements(lookupSet);
    }

    public static boolean completeReference(CompletionParameters parameters2, CompletionResultSet result2) {
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters2);
        if (completionData == null) {
            return false;
        }
        Ref hasVariants = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences(parameters2, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, resultSet) -> {
            LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
            completionData.completeReference((PsiReference)reference, (Set<LookupElement>)lookupSet, parameters2.getPosition(), parameters2.getOriginalFile());
            for (LookupElement item : lookupSet) {
                if (!resultSet.getPrefixMatcher().prefixMatches(item)) continue;
                if (!item.isValid()) {
                    LOG.error(completionData + " has returned an invalid lookup element " + item + " of " + item.getClass() + " in " + parameters2.getOriginalFile() + " of " + parameters2.getOriginalFile().getClass() + "; reference=" + reference + " of " + reference.getClass());
                }
                hasVariants.set((Object)true);
                resultSet.addElement(item);
            }
        }));
        return (Boolean)hasVariants.get();
    }

    private static CompletionData getCompletionData(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        return CompletionUtil.getCompletionDataByElement(position, parameters2.getOriginalFile());
    }

    public static void processReferences(CompletionParameters parameters2, CompletionResultSet result2, PairConsumer<PsiReference, CompletionResultSet> consumer2) {
        int startOffset = parameters2.getOffset();
        PsiReference ref = parameters2.getPosition().getContainingFile().findReferenceAt(startOffset);
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : CompletionData.getReferences((PsiMultiReference)ref)) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer2, reference);
            }
        } else if (ref instanceof PsiDynaReference) {
            for (PsiReference reference : ((PsiDynaReference)ref).getReferences()) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer2, reference);
            }
        } else if (ref != null) {
            LegacyCompletionContributor.processReference(result2, startOffset, consumer2, ref);
        }
    }

    private static void processReference(CompletionResultSet result2, int startOffset, PairConsumer<PsiReference, CompletionResultSet> consumer2, PsiReference reference) {
        PsiElement element = reference.getElement();
        int offsetInElement = startOffset - element.getTextRange().getStartOffset();
        if (!ReferenceRange.containsOffsetInElement((PsiReference)reference, (int)offsetInElement)) {
            return;
        }
        TextRange range = reference.getRangeInElement();
        try {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            consumer2.consume((Object)reference, (Object)result2.withPrefixMatcher(prefix));
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Reference=" + reference + "; element=" + element + " of " + element.getClass() + "; range=" + range + "; offset=" + offsetInElement, (Throwable)e);
        }
    }
}

