/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MethodReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance((String)("#" + MethodReferenceCompletionProvider.class.getName()));

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, final @NotNull CompletionResultSet result2) {
        ExpectedTypeInfo[] expectedTypes;
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters2.getOriginalFile())) {
            return;
        }
        PsiElement rulezzRef = parameters2.getPosition().getParent();
        if (rulezzRef == null || !LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiType functionalType;
            PsiType returnType;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)(functionalType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            PsiElement position = parameters2.getPosition();
            final PsiElement refPlace = position.getParent();
            ExpectedTypeInfoImpl typeInfo = new ExpectedTypeInfoImpl(returnType, 1, returnType, TailType.UNKNOWN, null, ExpectedTypeInfoImpl.NULL);
            final Map map2 = LambdaUtil.getFunctionalTypeMap();
            Consumer<LookupElement> noTypeCheck = new Consumer<LookupElement>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void consume(LookupElement lookupElement) {
                    PsiElement element = lookupElement.getPsiElement();
                    if (element instanceof PsiMethod) {
                        PsiMethodReferenceExpression referenceExpression = this.createMethodReferenceExpression((PsiMethod)element);
                        if (referenceExpression == null) {
                            return;
                        }
                        PsiType added = map2.put(referenceExpression, functionalType);
                        try {
                            PsiElement resolve2 = referenceExpression.resolve();
                            if (resolve2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)resolve2) && PsiMethodReferenceUtil.checkMethodReferenceContext((PsiMethodReferenceExpression)referenceExpression, (PsiElement)resolve2, (PsiType)functionalType) == null) {
                                result2.addElement((LookupElement)new JavaMethodReferenceElement((PsiMethod)element, refPlace));
                            }
                        }
                        finally {
                            if (added == null) {
                                map2.remove(referenceExpression);
                            }
                        }
                    }
                }

                private PsiMethodReferenceExpression createMethodReferenceExpression(PsiMethod method2) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method2.getProject());
                    if (refPlace instanceof PsiMethodReferenceExpression) {
                        PsiMethodReferenceExpression referenceExpression = (PsiMethodReferenceExpression)refPlace.copy();
                        PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
                        LOG.assertTrue(referenceNameElement != null, (Object)referenceExpression);
                        referenceNameElement.replace((PsiElement)(method2.isConstructor() ? elementFactory.createKeyword("new") : elementFactory.createIdentifier(method2.getName())));
                        return referenceExpression;
                    }
                    if (method2.hasModifierProperty("static")) {
                        PsiClass aClass = method2.getContainingClass();
                        LOG.assertTrue(aClass != null);
                        String qualifiedName = aClass.getQualifiedName();
                        return (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(qualifiedName + "::" + (method2.isConstructor() ? "new" : method2.getName()), refPlace);
                    }
                    return null;
                }
            };
            Runnable runnable2 = ReferenceExpressionCompletionContributor.fillCompletionVariants(new JavaSmartCompletionParameters(parameters2, typeInfo), noTypeCheck);
            if (runnable2 == null) continue;
            runnable2.run();
        }
    }

    private static class JavaMethodReferenceElement
    extends JavaMethodCallElement {
        private final PsiMethod myMethod;
        private final PsiElement myRefPlace;

        public JavaMethodReferenceElement(PsiMethod method2, PsiElement refPlace) {
            super(method2, method2.isConstructor() ? "new" : method2.getName());
            this.myMethod = method2;
            this.myRefPlace = refPlace;
        }

        @Override
        public void handleInsert(InsertionContext context) {
            if (!(this.myRefPlace instanceof PsiMethodReferenceExpression)) {
                PsiClass containingClass = this.myMethod.getContainingClass();
                LOG.assertTrue(containingClass != null);
                String qualifiedName = containingClass.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int startOffset = context.getStartOffset();
                document.insertString(startOffset, (CharSequence)(qualifiedName + "::"));
                JavaCompletionUtil.shortenReference(context.getFile(), startOffset + qualifiedName.length() - 1);
                JavaCompletionUtil.insertTail(context, (LookupElement)this, JavaMethodReferenceElement.handleCompletionChar(context.getEditor(), (LookupElement)this, context.getCompletionChar()), false);
            }
        }
    }
}

