/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "mapOffsets", "newFile", "offsetFun", "Lkotlin/Function1;", "toFileCopy", "copyFile", "toInjectedIfAny", "offset", "toTopLevelFile", "lang-impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        OffsetsInFile offsetsInFile;
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile((PsiElement)this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            offsetsInFile = this;
        } else {
            PsiFile psiFile = hostFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"hostFile");
            offsetsInFile = this.mapOffsets(psiFile, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(this, manager){
                final /* synthetic */ OffsetsInFile this$0;
                final /* synthetic */ InjectedLanguageManager $manager;

                public final int invoke(int it) {
                    return this.$manager.injectedToHost((PsiElement)this.this$0.getFile(), it);
                }
                {
                    this.this$0 = offsetsInFile;
                    this.$manager = injectedLanguageManager;
                    super(1);
                }
            }));
        }
        return offsetsInFile;
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit(this.file, offset);
        if (psiFile == null) {
            return this;
        }
        PsiFile injected = psiFile;
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
        if (documentWindow == null) {
            Intrinsics.throwNpe();
        }
        DocumentWindow documentWindow2 = documentWindow;
        PsiFile psiFile2 = injected;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"injected");
        return this.mapOffsets(psiFile2, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(documentWindow2){
            final /* synthetic */ DocumentWindow $documentWindow;

            public final int invoke(int it) {
                return this.$documentWindow.hostToInjected(it);
            }
            {
                this.$documentWindow = documentWindow;
                super(1);
            }
        }));
    }

    @NotNull
    public final OffsetsInFile toFileCopy(@NotNull PsiFile copyFile) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)copyFile, (String)"copyFile");
        CompletionAssertions.assertCorrectOriginalFile("Given ", this.file, copyFile);
        Document document = copyFile.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        int n = document.getTextLength();
        Document document2 = this.file.getViewProvider().getDocument();
        if (document2 == null) {
            Intrinsics.throwNpe();
        }
        boolean bl2 = bl = n == document2.getTextLength();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.mapOffsets(copyFile, (Function1<? super Integer, Integer>)((Function1)toFileCopy.1.INSTANCE));
    }

    private final OffsetsInFile mapOffsets(PsiFile newFile, Function1<? super Integer, Integer> offsetFun) {
        Document document = newFile.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        OffsetMap map2 = new OffsetMap(document);
        for (OffsetKey key2 : this.offsets.getAllOffsets()) {
            map2.addOffset(key2, ((Number)offsetFun.invoke((Object)this.offsets.getOffset(key2))).intValue());
        }
        return new OffsetsInFile(newFile, map2);
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        PsiFile fileCopy = (PsiFile)psiElement;
        Document document = fileCopy.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document document2 = document;
        Document document3 = this.file.getViewProvider().getDocument();
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        document2.setText(document3.getImmutableCharSequence());
        OffsetsInFile result2 = this.toFileCopy(fileCopy);
        document2.replaceString(startOffset, endOffset, (CharSequence)replacement);
        PsiDocumentManager.getInstance((Project)this.file.getProject()).commitDocument(document2);
        return result2;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2, @NotNull OffsetMap offsets) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)offsets, (String)"offsets");
        this.file = file2;
        this.offsets = offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Document document = file2.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        this(file2, new OffsetMap(document));
    }
}

