/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ToArrayConversion {
    static void addConversions(PsiElement element, String prefix, PsiType itemType, Consumer<LookupElement> result2, @Nullable PsiElement qualifier, PsiType expectedType) {
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)itemType, (boolean)true);
        if (componentType == null || !(expectedType instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType type2 = (PsiArrayType)expectedType;
        if (!type2.getComponentType().isAssignableFrom(componentType) || componentType instanceof PsiClassType && ((PsiClassType)componentType).hasParameters()) {
            return;
        }
        String bracketSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
        boolean hasEmptyArrayField = false;
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass != null) {
            for (PsiField field : psiClass.getAllFields()) {
                boolean needQualify;
                if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, element, null) || !type2.isAssignableFrom(field.getType()) || !ConstructionUtils.isEmptyArrayInitializer(field.getInitializer())) continue;
                try {
                    needQualify = !field.isEquivalentTo(((PsiReferenceExpression)ReferenceExpressionCompletionContributor.createExpression(field.getName(), element)).resolve());
                }
                catch (IncorrectOperationException e) {
                    continue;
                }
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                ToArrayConversion.addToArrayConversion(element, prefix, (needQualify ? containingClass.getQualifiedName() + "." : "") + field.getName(), (needQualify ? containingClass.getName() + "." : "") + field.getName(), result2, qualifier);
                hasEmptyArrayField = true;
            }
        }
        if (!hasEmptyArrayField) {
            ToArrayConversion.addToArrayConversion(element, prefix, "new " + componentType.getCanonicalText() + "[" + bracketSpace + "0" + bracketSpace + "]", "new " + componentType.getPresentableText() + "[0]", result2, qualifier);
        }
    }

    private static void addToArrayConversion(PsiElement element, String prefix, @NonNls String expressionString, @NonNls String presentableString, Consumer<LookupElement> result2, PsiElement qualifier) {
        PsiExpression conversion;
        boolean callSpace = CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        try {
            conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")", element);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        String[] lookupStrings = new String[]{prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")", presentableString};
        result2.consume((Object)new ExpressionLookupItem(conversion, PlatformIcons.METHOD_ICON, prefix + ".toArray(" + presentableString + ")", lookupStrings){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.toar");
                context.commitDocument();
                JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)context.getFile(), context.getStartOffset(), context.getTailOffset());
            }
        });
    }
}

