/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageWordCompletion;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WordCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2.getCompletionType() == CompletionType.BASIC && WordCompletionContributor.shouldPerformWordCompletion(parameters2)) {
            WordCompletionContributor.addWordCompletionVariants(result2, parameters2, Collections.emptySet());
        }
    }

    public static void addWordCompletionVariants(CompletionResultSet result2, CompletionParameters parameters2, Set<String> excludes) {
        HashSet<String> realExcludes = new HashSet<String>(excludes);
        for (String exclude : excludes) {
            String[] words = exclude.split("[ \\.-]");
            if (words.length <= 0 || !StringUtil.isNotEmpty((String)words[0])) continue;
            realExcludes.add(words[0]);
        }
        int startOffset = parameters2.getOffset();
        PsiElement position = parameters2.getPosition();
        CompletionResultSet javaResultSet = result2.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix(parameters2));
        CompletionResultSet plainResultSet = result2.withPrefixMatcher(CompletionUtil.findAlphanumericPrefix(parameters2));
        for (String word : WordCompletionContributor.getAllWords(position, startOffset)) {
            if (realExcludes.contains(word)) continue;
            LookupElementBuilder item = LookupElementBuilder.create((String)word);
            javaResultSet.addElement((LookupElement)item);
            plainResultSet.addElement((LookupElement)item);
        }
        WordCompletionContributor.addValuesFromOtherStringLiterals(result2, parameters2, realExcludes, position);
    }

    private static void addValuesFromOtherStringLiterals(CompletionResultSet result2, CompletionParameters parameters2, Set<String> realExcludes, PsiElement position) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(position.getLanguage());
        if (definition == null) {
            return;
        }
        PsiElementPattern pattern = PlatformPatterns.psiElement().withElementType(definition.getStringLiteralElements());
        final PsiElement localString = PsiTreeUtil.findFirstParent((PsiElement)position, (boolean)false, arg_0 -> WordCompletionContributor.lambda$addValuesFromOtherStringLiterals$0((ElementPattern)pattern, arg_0));
        if (localString == null) {
            return;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)localString);
        if (manipulator == null) {
            return;
        }
        int offset = manipulator.getRangeInElement(localString).getStartOffset();
        PsiFile file2 = position.getContainingFile();
        CompletionResultSet fullStringResult = result2.withPrefixMatcher(file2.getText().substring(offset + localString.getTextRange().getStartOffset(), parameters2.getOffset()));
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((ElementPattern)pattern, realExcludes, fullStringResult){
            final /* synthetic */ ElementPattern val$pattern;
            final /* synthetic */ Set val$realExcludes;
            final /* synthetic */ CompletionResultSet val$fullStringResult;
            {
                this.val$pattern = elementPattern;
                this.val$realExcludes = set2;
                this.val$fullStringResult = completionResultSet;
            }

            public void visitElement(PsiElement element) {
                if (element == localString) {
                    return;
                }
                if (this.val$pattern.accepts((Object)element)) {
                    element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement each) {
                            String valueText = ElementManipulators.getValueText((PsiElement)each);
                            if (StringUtil.isNotEmpty((String)valueText) && !val$realExcludes.contains(valueText)) {
                                LookupElementBuilder item = LookupElementBuilder.create((String)valueText);
                                val$fullStringResult.addElement((LookupElement)item);
                            }
                        }
                    });
                    return;
                }
                super.visitElement(element);
            }
        });
    }

    private static boolean shouldPerformWordCompletion(CompletionParameters parameters2) {
        ASTNode textContainer;
        int startOffset;
        PsiReference reference;
        PsiElement insertedElement = parameters2.getPosition();
        boolean dumb = DumbService.getInstance((Project)insertedElement.getProject()).isDumb();
        if (dumb) {
            return true;
        }
        if (parameters2.getInvocationCount() == 0) {
            return false;
        }
        PsiFile file2 = insertedElement.getContainingFile();
        CompletionData data = CompletionUtil.getCompletionDataByElement(insertedElement, file2);
        if (data != null) {
            HashSet<CompletionVariant> toAdd = new HashSet<CompletionVariant>();
            data.addKeywordVariants(toAdd, insertedElement, file2);
            for (CompletionVariant completionVariant : toAdd) {
                if (!completionVariant.hasKeywordCompletions()) continue;
                return false;
            }
        }
        if ((reference = file2.findReferenceAt(startOffset = parameters2.getOffset())) != null) {
            return false;
        }
        PsiElement element = file2.findElementAt(startOffset - 1);
        ASTNode aSTNode = textContainer = element != null ? element.getNode() : null;
        while (textContainer != null) {
            IElementType elementType = textContainer.getElementType();
            if (LanguageWordCompletion.INSTANCE.isEnabledIn(elementType) || elementType == PlainTextTokenTypes.PLAIN_TEXT) {
                return true;
            }
            textContainer = textContainer.getTreeParent();
        }
        return false;
    }

    public static Set<String> getAllWords(PsiElement context, final int offset) {
        final LinkedHashSet<String> words = new LinkedHashSet<String>();
        if (StringUtil.isEmpty((String)CompletionUtil.findJavaIdentifierPrefix(context, offset))) {
            return words;
        }
        CharSequence chars = context.getContainingFile().getViewProvider().getContents();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, @Nullable char[] charsArray, int start, int end) {
                if (start > offset || offset > end) {
                    words.add(chars.subSequence(start, end).toString());
                }
            }
        }, chars, 0, chars.length());
        return words;
    }

    private static /* synthetic */ boolean lambda$addValuesFromOtherStringLiterals$0(ElementPattern pattern, PsiElement element) {
        return pattern.accepts((Object)element);
    }
}

